/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input;

import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfThen;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsSpecificUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import io.atlassian.fugue.Option;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BuilderServiceImplHelper {
    private static final Logger log = LoggerFactory.getLogger(BuilderServiceImplHelper.class);
    private final ProjectService projectService;
    private final UserManager userManager;

    @Autowired
    BuilderServiceImplHelper(ProjectService projectService, UserManager userManager) {
        this.projectService = projectService;
        this.userManager = userManager;
    }

    void populateBuilderRules(RuleSetInputBuilder ruleSetInputBuilder, List<Rule> rules) {
        rules.stream().forEach(rule -> this.addRuleToBuilder(ruleSetInputBuilder.rule(), (Rule)rule));
    }

    void addUserContextToBuilder(RuleSetInputBuilder builder, RunAsUserContextConfig runAsUserContextConfig) {
        if (runAsUserContextConfig.getType().equals("currentUser")) {
            builder.metadata().userContext().runAsCurrentUser();
        } else if (runAsUserContextConfig.getType().equals("specificUser")) {
            RunAsSpecificUserContextConfig specificUserConfig = (RunAsSpecificUserContextConfig)runAsUserContextConfig;
            String configuredUserKey = specificUserConfig.getUserKey();
            ApplicationUser user = this.userManager.getUserByKey(configuredUserKey);
            if (user != null) {
                builder.metadata().userContext().runAs(user);
            } else {
                log.debug("User context could not be added to the builder because a user with Key '" + configuredUserKey + "' could not be found.");
            }
        }
    }

    void addProjectsToBuilder(RuleSetInputBuilder builder, ProjectContextConfig projectContextConfig) {
        if (projectContextConfig.isGlobal()) {
            builder.metadata().projectContext().global();
        } else {
            this.retrieveFirstValidProject(projectContextConfig).forEach(project -> this.addProjectToBuilder(builder.metadata(), (Project)project));
        }
    }

    private Option<Project> retrieveFirstValidProject(ProjectContextConfig projectContextConfig) {
        return Option.option(projectContextConfig.getProjectIds().stream().map(arg_0 -> ((ProjectService)this.projectService).getProjectById(arg_0)).filter(ServiceResultImpl::isValid).map(ProjectService.AbstractProjectResult::getProject).findFirst().orElse(null));
    }

    private void addProjectToBuilder(RuleSetInputBuilder.RuleSetMetadataBuilder ruleSetMetadataBuilder, Project project) {
        ruleSetMetadataBuilder.projectContext().project(project);
    }

    private void addRuleToBuilder(RuleSetInputBuilder.RuleBuilder ruleBuilder, Rule rule) {
        rule.getWhen().getWhenHandlerConfigurations().stream().forEach(whenConfig -> this.addWhenHandlerToBuilder(ruleBuilder, (WhenHandlerConfiguration)whenConfig));
        rule.getIfThens().stream().forEach(ifThen -> this.addIfThenToBuilder(ruleBuilder.ifThen(), (IfThen)ifThen));
        ruleBuilder.enabled(rule.isEnabled());
    }

    private void addWhenHandlerToBuilder(RuleSetInputBuilder.RuleBuilder ruleBuilder, WhenHandlerConfiguration whenHandlerConfiguration) {
        ruleBuilder.when().whenHandler().moduleKey(whenHandlerConfiguration.getModuleKey()).data(whenHandlerConfiguration.getData());
    }

    private void addIfThenToBuilder(RuleSetInputBuilder.IfThenBuilder ifThenBuilder, IfThen ifThen) {
        ifThen.getIf().getIfConditionConfigurations().stream().forEach(ifCondition -> this.addIfToBuilder(ifThenBuilder.ruleIf(), (IfConditionConfiguration)ifCondition));
        ifThen.getThen().getThenActionConfigurations().stream().forEach(thenAction -> this.addThenActionToBuilder(ifThenBuilder.ruleThen(), (ThenActionConfiguration)thenAction));
    }

    private void addIfToBuilder(RuleSetInputBuilder.IfBuilder ifBuilder, IfConditionConfiguration ifConditionConfiguration) {
        ifBuilder.ifCondition().moduleKey(ifConditionConfiguration.getModuleKey()).data(ifConditionConfiguration.getData());
    }

    private void addThenActionToBuilder(RuleSetInputBuilder.ThenBuilder thenBuilder, ThenActionConfiguration thenActionConfiguration) {
        thenBuilder.thenAction().moduleKey(thenActionConfiguration.getModuleKey()).data(thenActionConfiguration.getData());
    }
}

