/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.RuleSetProjectContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.ConfigurationDataBuilder;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RuleSetRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfigFactory;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.BuilderServiceImplHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ConfigurationDataBuilderImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleSetInputBuilderImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.user.RunAsUserContextConfigFactoryImpl;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class BuilderServiceImpl
implements BuilderService {
    private RuleSetProjectContextConfigService ruleSetProjectContextConfigService;
    private RuleSetRunAsUserContextConfigService ruleSetRunAsUserContextConfigService;
    private BuilderServiceImplHelper builderServiceImplHelper;

    @Autowired
    public BuilderServiceImpl(RuleSetProjectContextConfigService ruleSetProjectContextConfigService, RuleSetRunAsUserContextConfigService ruleSetRunAsUserContextConfigService, BuilderServiceImplHelper builderServiceImplHelper) {
        this.ruleSetProjectContextConfigService = ruleSetProjectContextConfigService;
        this.ruleSetRunAsUserContextConfigService = ruleSetRunAsUserContextConfigService;
        this.builderServiceImplHelper = builderServiceImplHelper;
    }

    public RuleSetInputBuilder newRuleSetBuilder() {
        return RuleSetInputBuilderImpl.newBuilder();
    }

    public ConfigurationDataBuilder newConfigurationDataBuilder() {
        return ConfigurationDataBuilderImpl.newBuilder();
    }

    public RunAsUserContextConfigFactory newRunAsUserContextConfigFactory() {
        return new RunAsUserContextConfigFactoryImpl();
    }

    public Either<AnError, RuleSetInputBuilder> newBuilderFromRuleSet(@Nonnull RuleSet existingRuleSet) {
        return Steps.begin(this.getProjectContextConfig(existingRuleSet)).then(projectContextConfig -> this.getRunAsUserContextConfig(existingRuleSet)).yield((projectContextConfig, runAsUserContextConfigs) -> this.populateBuilder((ProjectContextConfig)projectContextConfig, (Option<RunAsUserContextConfig>)runAsUserContextConfigs, existingRuleSet));
    }

    private Either<AnError, ProjectContextConfig> getProjectContextConfig(RuleSet ruleSet) {
        return this.ruleSetProjectContextConfigService.getProjectContextConfigForRuleSet(ruleSet);
    }

    private Either<AnError, Option<RunAsUserContextConfig>> getRunAsUserContextConfig(RuleSet ruleset) {
        return this.ruleSetRunAsUserContextConfigService.getRunAsUserContextConfigForRuleSet(ruleset);
    }

    private RuleSetInputBuilder populateBuilder(ProjectContextConfig projectContextConfig, Option<RunAsUserContextConfig> runAsUserContextConfig, RuleSet ruleSet) {
        RuleSetInputBuilder builder = this.newRuleSetBuilder();
        builder.id(Long.valueOf(ruleSet.getId())).name(ruleSet.getName()).isSystemRuleSet(ruleSet.isSystemRuleSet()).metadata().triggerFromOtherRules(Boolean.valueOf(ruleSet.getTriggerFromOtherRules()));
        ruleSet.getDescription().foreach(arg_0 -> ((RuleSetInputBuilder)builder).description(arg_0));
        runAsUserContextConfig.foreach(config -> this.builderServiceImplHelper.addUserContextToBuilder(builder, (RunAsUserContextConfig)config));
        this.builderServiceImplHelper.addProjectsToBuilder(builder, projectContextConfig);
        this.builderServiceImplHelper.populateBuilderRules(builder, ruleSet.getRules());
        return builder;
    }
}

