/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QWhenHandlerConfigData;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ConfigurationDataImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.ConfigDataDao;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

final class WhenHandlerConfigDataDao
extends ConfigDataDao {
    WhenHandlerConfigDataDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper) {
        super(databaseAccessor, helper);
    }

    @Override
    protected SQLInsertClause createInsertStatement(DatabaseConnection connection, long whenHandlerConfigId, ConfigurationData configurationData) {
        SQLInsertClause batchInsertStatement = connection.insert((RelationalPath)Tables.WHEN_HANDLER_CONFIG_DATA);
        for (Map.Entry configDataEntry : configurationData.getAll().entrySet()) {
            batchInsertStatement.set(Tables.WHEN_HANDLER_CONFIG_DATA.WHEN_HANDLER_CONFIG_ID, (Object)whenHandlerConfigId);
            batchInsertStatement.set((Path)Tables.WHEN_HANDLER_CONFIG_DATA.CONFIG_DATA_KEY, configDataEntry.getKey());
            batchInsertStatement.set((Path)Tables.WHEN_HANDLER_CONFIG_DATA.CONFIG_DATA_VALUE, configDataEntry.getValue());
            batchInsertStatement.addBatch();
        }
        return batchInsertStatement;
    }

    public Map<Long, ConfigurationData> getForRuleSetRevisionIds(List<Long> ruleSetRevisionIds) {
        Stream<Map> rowStream = Lists.partition(ruleSetRevisionIds, (int)1000).stream().flatMap(ids -> ((List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QWhenHandlerConfigData.Row.class, Tables.WHEN_HANDLER_CONFIG_DATA)).from((Expression)Tables.WHEN_HANDLER_CONFIG_DATA)).join((EntityPath)Tables.WHEN_HANDLER_CONFIG)).on((Predicate)Tables.WHEN_HANDLER_CONFIG.ID.eq(Tables.WHEN_HANDLER_CONFIG_DATA.WHEN_HANDLER_CONFIG_ID))).join((EntityPath)Tables.RULE)).on((Predicate)Tables.RULE.ID.eq(Tables.WHEN_HANDLER_CONFIG.RULE_ID))).where((Predicate)Tables.RULE.RULESET_REVISION_ID.in((Collection)ids))).fetch())).stream());
        return rowStream.collect(Collectors.collectingAndThen(Collectors.groupingBy(row -> row.whenHandlerConfigId, Collectors.collectingAndThen(Collectors.toList(), this::loadConfigDataFromDbRows)), Collections::unmodifiableMap));
    }

    public ConfigurationData getForWhenHandlerConfigWithId(long whenHandlerConfigId) {
        List returnedRows = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QWhenHandlerConfigData.Row.class, Tables.WHEN_HANDLER_CONFIG_DATA)).from((Expression)Tables.WHEN_HANDLER_CONFIG_DATA)).where((Predicate)Tables.WHEN_HANDLER_CONFIG_DATA.WHEN_HANDLER_CONFIG_ID.eq((Object)whenHandlerConfigId))).fetch());
        if (returnedRows.isEmpty()) {
            return ConfigurationDataImpl.EMPTY_INSTANCE;
        }
        return this.loadConfigDataFromDbRows(returnedRows);
    }

    private ConfigurationData loadConfigDataFromDbRows(List<QWhenHandlerConfigData.Row> dbRows) {
        ImmutableMap.Builder configDataMap = ImmutableMap.builder();
        for (QWhenHandlerConfigData.Row row : dbRows) {
            configDataMap.put((Object)row.configDataKey, (Object)StringUtils.defaultString((String)row.configDataValue));
        }
        return new ConfigurationDataImpl((Map<String, String>)configDataMap.build());
    }
}

