/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QWhenHandlerConfig;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ConfigurationDataImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ProcessedComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.WhenHandlerConfigDataDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.store.ConfigurationProcessorManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

final class WhenHandlerConfigDao
extends QueryDslDao {
    private final WhenHandlerConfigDataDao configDataDao;
    private final ConfigurationProcessorManager configurationProcessorManager;

    WhenHandlerConfigDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper, ConfigurationProcessorManager configurationProcessorManager) {
        super(databaseAccessor, helper);
        this.configurationProcessorManager = configurationProcessorManager;
        this.configDataDao = new WhenHandlerConfigDataDao(databaseAccessor, helper);
    }

    long create(@Nonnull DatabaseConnection connection, long ruleId, @Nonnull WhenHandlerConfiguration whenHandlerConfig, int ordinal) {
        Assertions.notNull((String)"connection is required", (Object)connection);
        Assertions.notNull((String)"whenHandlerConfig is required", (Object)whenHandlerConfig);
        Assertions.isTrue((String)"ordinal cannot be negative", (ordinal >= 0 ? 1 : 0) != 0);
        long createdWhenHandlerConfigId = this.insertWhenHandlerConfig(connection, ruleId, whenHandlerConfig, ordinal);
        ConfigurationData convertedConfigData = this.configurationProcessorManager.preStore(whenHandlerConfig);
        this.configDataDao.create(connection, createdWhenHandlerConfigId, convertedConfigData);
        return createdWhenHandlerConfigId;
    }

    private long insertWhenHandlerConfig(DatabaseConnection connection, long ruleId, WhenHandlerConfiguration whenHandlerConfig, int ordinal) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.WHEN_HANDLER_CONFIG).set(Tables.WHEN_HANDLER_CONFIG.RULE_ID, (Object)ruleId).set((Path)Tables.WHEN_HANDLER_CONFIG.MODULE_KEY, (Object)whenHandlerConfig.getModuleKey()).set(Tables.WHEN_HANDLER_CONFIG.ORDINAL, (Object)ordinal);
        return this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.WHEN_HANDLER_CONFIG.getTableName());
    }

    public Map<Long, List<WhenHandlerConfiguration>> getForRuleSetRevisionIds(List<Long> ruleSetRevisionIds) {
        Map<Long, ConfigurationData> config = this.configDataDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        Stream<Map> rowStream = Lists.partition(ruleSetRevisionIds, (int)1000).stream().flatMap(ids -> ((List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QWhenHandlerConfig.Row.class, Tables.WHEN_HANDLER_CONFIG)).from((Expression)Tables.WHEN_HANDLER_CONFIG)).join((EntityPath)Tables.RULE)).on((Predicate)Tables.RULE.ID.eq(Tables.WHEN_HANDLER_CONFIG.RULE_ID))).where((Predicate)Tables.RULE.RULESET_REVISION_ID.in((Collection)ids))).orderBy(Tables.WHEN_HANDLER_CONFIG.ORDINAL.asc())).fetch())).stream());
        return rowStream.collect(Collectors.collectingAndThen(Collectors.groupingBy(row -> row.ruleId, Collectors.mapping(row -> this.createWhenHandlerConfiguration((QWhenHandlerConfig.Row)row, (ConfigurationData)config.get(row.id)), Collectors.toList())), Collections::unmodifiableMap));
    }

    public WhenHandlerConfiguration createWhenHandlerConfiguration(QWhenHandlerConfig.Row row, ConfigurationData config) {
        return new ProcessedComponentConfigurationImpl(row.id, row.moduleKey, config == null ? ConfigurationDataImpl.EMPTY_INSTANCE : config, this.configurationProcessorManager);
    }

    public List<WhenHandlerConfiguration> getAllForRuleWithId(long ruleId) {
        List returnedRows = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QWhenHandlerConfig.Row.class, Tables.WHEN_HANDLER_CONFIG)).from((Expression)Tables.WHEN_HANDLER_CONFIG)).where((Predicate)Tables.WHEN_HANDLER_CONFIG.RULE_ID.eq((Object)ruleId))).orderBy(Tables.WHEN_HANDLER_CONFIG.ORDINAL.asc())).fetch());
        if (returnedRows.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadWhenHandlerConfigsFromDbRows(returnedRows);
    }

    private List<WhenHandlerConfiguration> loadWhenHandlerConfigsFromDbRows(List<QWhenHandlerConfig.Row> dbRows) {
        ImmutableList.Builder loadedWhenHandlerConfigs = ImmutableList.builder();
        for (QWhenHandlerConfig.Row row : dbRows) {
            loadedWhenHandlerConfigs.add((Object)this.loadWhenHandlerConfigFromDbRow(row));
        }
        return loadedWhenHandlerConfigs.build();
    }

    private WhenHandlerConfiguration loadWhenHandlerConfigFromDbRow(QWhenHandlerConfig.Row row) {
        ConfigurationData configDataForWhenHandlerConfig = this.configDataDao.getForWhenHandlerConfigWithId(row.id);
        return new ProcessedComponentConfigurationImpl(row.id, row.moduleKey, configDataForWhenHandlerConfig, this.configurationProcessorManager);
    }
}

