/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfigFactory;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QRuleSetRevision;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.RuleDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.RuleSetRevisionProjectContextDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.RuleSetRevisionUserContextDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.store.ConfigurationProcessorManager;
import com.atlassian.util.concurrent.Assertions;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

final class RuleSetRevisionDao
extends QueryDslDao {
    private final RuleDao ruleDao;
    private final RuleSetRevisionUserContextDao ruleSetRevisionUserContextDao;
    private final RuleSetRevisionProjectContextDao ruleSetRevisionProjectContextDao;

    RuleSetRevisionDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper, RunAsUserContextConfigFactory runAsUserContextConfigFactory, ConfigurationProcessorManager configurationProcessorManager) {
        super(databaseAccessor, helper);
        this.ruleDao = new RuleDao(databaseAccessor, helper, configurationProcessorManager);
        this.ruleSetRevisionUserContextDao = new RuleSetRevisionUserContextDao(databaseAccessor, helper, runAsUserContextConfigFactory);
        this.ruleSetRevisionProjectContextDao = new RuleSetRevisionProjectContextDao(databaseAccessor, helper);
    }

    long create(@Nonnull DatabaseConnection connection, @Nonnull List<Rule> rules, long ruleSetId, @Nonnull String name, @Nonnull Option<String> description, @Nonnull Option<RunAsUserContextConfig> runAsUserContext, @Nonnull ProjectContextConfig projectContextConfig, @Nonnull String createdBy, boolean triggerFromOtherRules, boolean isSystemRuleSet) {
        Assertions.notNull((String)"connection is required", (Object)connection);
        Assertions.notNull((String)"rules is required", rules);
        Assertions.isTrue((String)"name is required", (boolean)StringUtils.isNotBlank((CharSequence)name));
        Assertions.notNull((String)"description is required", description);
        Assertions.notNull((String)"runAsUserContext is required", runAsUserContext);
        Assertions.notNull((String)"projectContextConfig is required", (Object)projectContextConfig);
        Assertions.isTrue((String)"createdBy is required", (boolean)StringUtils.isNotBlank((CharSequence)createdBy));
        Timestamp insertedTimestamp = QueryDslDaoHelper.now();
        long createdRuleSetRevisionId = this.insertRuleSetRevision(connection, ruleSetId, name, description, insertedTimestamp, createdBy, triggerFromOtherRules, isSystemRuleSet);
        this.insertRules(connection, rules, createdRuleSetRevisionId);
        this.insertUserContext(connection, runAsUserContext, createdRuleSetRevisionId);
        this.insertProjectContext(connection, projectContextConfig, createdRuleSetRevisionId);
        return createdRuleSetRevisionId;
    }

    private void insertProjectContext(DatabaseConnection connection, ProjectContextConfig projectContextConfig, long createdRuleSetRevisionId) {
        this.ruleSetRevisionProjectContextDao.create(connection, createdRuleSetRevisionId, projectContextConfig);
    }

    private void insertUserContext(DatabaseConnection connection, Option<RunAsUserContextConfig> runAsUserContext, long createdRuleSetRevisionId) {
        this.ruleSetRevisionUserContextDao.create(connection, createdRuleSetRevisionId, runAsUserContext);
    }

    private long insertRuleSetRevision(DatabaseConnection connection, long ruleSetId, String name, Option<String> description, Timestamp insertedTimestamp, String createdBy, boolean triggerFromOtherRules, boolean isSystemRuleSet) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.RULE_SET_REVISION).set(Tables.RULE_SET_REVISION.RULE_SET_ID, (Object)ruleSetId).set((Path)Tables.RULE_SET_REVISION.NAME, (Object)name).set((Path)Tables.RULE_SET_REVISION.DESCRIPTION, description.getOrNull()).set((Path)Tables.RULE_SET_REVISION.CREATED_BY, (Object)createdBy).set((Path)Tables.RULE_SET_REVISION.TRIGGER_FROM_OTHER_RULES, (Object)triggerFromOtherRules).set(Tables.RULE_SET_REVISION.CREATED_TIMESTAMP_MILLIS, (Object)insertedTimestamp.getTime()).set((Path)Tables.RULE_SET_REVISION.IS_SYSTEM_RULE_SET, (Object)isSystemRuleSet);
        return this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.RULE_SET_REVISION.getTableName());
    }

    private void insertRules(DatabaseConnection connection, List<Rule> rules, Long createdRuleSetRevisionId) {
        for (int ruleIndex = 0; ruleIndex < rules.size(); ++ruleIndex) {
            this.ruleDao.create(connection, rules.get(ruleIndex), createdRuleSetRevisionId, ruleIndex + 0);
        }
    }

    Option<RuleSetRevision> getWhereIdIn(@Nonnull SQLQuery<Long> idSubQuery) {
        Assertions.notNull((String)"idSubQuery is required", idSubQuery);
        QRuleSetRevision.Row ruleSetRevisionRow = (QRuleSetRevision.Row)this.databaseAccessor.run(connection -> (QRuleSetRevision.Row)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRuleSetRevision.Row.class, Tables.RULE_SET_REVISION)).from((Expression)Tables.RULE_SET_REVISION)).where((Predicate)Tables.RULE_SET_REVISION.ID.in((SubQueryExpression)idSubQuery))).fetchOne());
        if (ruleSetRevisionRow == null) {
            return Option.none();
        }
        return Option.some((Object)this.buildRuleSetRevision(ruleSetRevisionRow));
    }

    List<RuleSetRevision> getActiveRuleSetRevisions() {
        List rows = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRuleSetRevision.Row.class, Tables.RULE_SET_REVISION)).from((Expression)Tables.RULE_SET_REVISION)).join((EntityPath)Tables.RULE_SET)).on((Predicate)Tables.RULE_SET_REVISION.ID.eq(Tables.RULE_SET.ACTIVE_REVISION_ID))).orderBy(Tables.RULE_SET.ID.asc())).fetch());
        List ruleSetRevisionIds = rows.stream().map(row -> row.id).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        Map<Long, ProjectContextConfig> projectCtxs = this.ruleSetRevisionProjectContextDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        Map<Long, RunAsUserContextConfig> runAsCtxs = this.ruleSetRevisionUserContextDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        Map<Long, List<Rule>> rules = this.ruleDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        return rows.stream().map(row -> this.createRuleSetRevision((QRuleSetRevision.Row)row, (List)rules.get(row.id), (Option<RunAsUserContextConfig>)Option.option(runAsCtxs.get(row.id)), (ProjectContextConfig)projectCtxs.get(row.id), row.isSystemRuleSet)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    Option<RuleSetRevision> getRuleSetRevision(long revisionId) {
        QRuleSetRevision.Row ruleSetRevisionRow = (QRuleSetRevision.Row)this.databaseAccessor.run(connection -> (QRuleSetRevision.Row)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRuleSetRevision.Row.class, Tables.RULE_SET_REVISION)).from((Expression)Tables.RULE_SET_REVISION)).where((Predicate)Tables.RULE_SET_REVISION.ID.eq((Object)revisionId))).fetchOne());
        if (ruleSetRevisionRow == null) {
            return Option.none();
        }
        return Option.some((Object)this.buildRuleSetRevision(ruleSetRevisionRow));
    }

    private RuleSetRevision buildRuleSetRevision(QRuleSetRevision.Row ruleSetRevisionRow) {
        List<Rule> rulesOfRulesetRevision = this.ruleDao.getAllForRuleSetRevisionWithId(ruleSetRevisionRow.id);
        Option<RunAsUserContextConfig> userContextConfigOfRevision = this.ruleSetRevisionUserContextDao.getForRuleSetRevisionWithId(ruleSetRevisionRow.id);
        ProjectContextConfig projectContextConfigOfRevision = this.ruleSetRevisionProjectContextDao.getForRuleSetRevisionWithId(ruleSetRevisionRow.id);
        return this.createRuleSetRevision(ruleSetRevisionRow, rulesOfRulesetRevision, userContextConfigOfRevision, projectContextConfigOfRevision, ruleSetRevisionRow.isSystemRuleSet);
    }

    private RuleSetRevision createRuleSetRevision(QRuleSetRevision.Row ruleSetRevisionRow, List<Rule> rules, Option<RunAsUserContextConfig> runAsCtx, ProjectContextConfig projectCtx, boolean isSystemRuleSet) {
        boolean triggerFromOtherRule = ruleSetRevisionRow.triggerFromOtherRules == null ? true : ruleSetRevisionRow.triggerFromOtherRules;
        return new RuleSetRevision(ruleSetRevisionRow.id, rules, ruleSetRevisionRow.ruleSetId, ruleSetRevisionRow.name, (Option<String>)Option.option((Object)ruleSetRevisionRow.description), triggerFromOtherRule, runAsCtx, projectCtx, isSystemRuleSet);
    }

    static class RuleSetRevision {
        final long id;
        final List<Rule> rules;
        final long ruleSetId;
        final String name;
        final Option<String> description;
        final boolean triggerFromOtherRules;
        final Option<RunAsUserContextConfig> runAsUserContextConfig;
        final ProjectContextConfig projectContextConfig;
        final boolean isSystemRuleSet;

        RuleSetRevision(long id, List<Rule> rules, long ruleSetId, String name, Option<String> description, boolean triggerFromOtherRules, Option<RunAsUserContextConfig> runAsUserContextConfig, ProjectContextConfig projectContextConfig, boolean isSystemRuleSet) {
            Assertions.notNull((String)"rules cannot be null", rules);
            Assertions.isTrue((String)"name is required", (boolean)StringUtils.isNotBlank((CharSequence)name));
            Assertions.notNull((String)"description option cannot be null", description);
            Assertions.notNull((String)"runAsUserContextConfig option cannot be null", runAsUserContextConfig);
            Assertions.notNull((String)"projectContextConfig option cannot be null", (Object)projectContextConfig);
            this.id = id;
            this.rules = rules;
            this.ruleSetId = ruleSetId;
            this.name = name;
            this.description = description;
            this.triggerFromOtherRules = triggerFromOtherRules;
            this.runAsUserContextConfig = runAsUserContextConfig;
            this.projectContextConfig = projectContextConfig;
            this.isSystemRuleSet = isSystemRuleSet;
        }
    }
}

