/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleSetImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.RuleSetDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.RuleSetRevisionDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.store.ConfigurationProcessorManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class RuleSetDaoImpl
extends QueryDslDao
implements RuleSetDao {
    private static final Logger log = LoggerFactory.getLogger(RuleSetDaoImpl.class);
    private final RuleSetRevisionDao ruleSetRevisionDao;

    @Autowired
    public RuleSetDaoImpl(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper, BuilderService builderService, ConfigurationProcessorManager configurationProcessorManager) {
        super(databaseAccessor, helper);
        this.ruleSetRevisionDao = new RuleSetRevisionDao(databaseAccessor, helper, builderService.newRunAsUserContextConfigFactory(), configurationProcessorManager);
    }

    @Override
    public RuleSet create(@Nonnull String name, @Nonnull io.atlassian.fugue.Option<String> description, @Nonnull List<Rule> rules, @Nonnull io.atlassian.fugue.Option<RunAsUserContextConfig> runAsUserContextConfigOpt, @Nonnull ProjectContextConfig projectContextConfig, @Nonnull String createdBy, boolean triggerFromOtherRules, boolean isSystemRuleSet) {
        Assertions.isTrue((String)"name is required", (boolean)StringUtils.isNotBlank((CharSequence)name));
        Assertions.notNull((String)"description is required", description);
        Assertions.notNull((String)"rules is required", rules);
        Assertions.notNull((String)"runAsUserContextConfigOpt is required", runAsUserContextConfigOpt);
        Assertions.notNull((String)"projectContextConfig is required", (Object)projectContextConfig);
        Assertions.isTrue((String)"createdBy is required", (boolean)StringUtils.isNotBlank((CharSequence)createdBy));
        return (RuleSet)this.databaseAccessor.runInTransaction(connection -> {
            log.debug("Saving new ruleset in the database with name: '{}'", (Object)name);
            long createdRuleSetId = this.insertRuleSet((DatabaseConnection)connection);
            long createdRevisionId = this.insertRuleSetRevisionAndUpdateActiveRevisionId((DatabaseConnection)connection, rules, createdRuleSetId, name, description, runAsUserContextConfigOpt, projectContextConfig, createdBy, triggerFromOtherRules, isSystemRuleSet);
            RuleSetImpl createdRuleset = new RuleSetImpl(createdRuleSetId, createdRevisionId, projectContextConfig, name, (Option<String>)StepsConverters.olderOption((io.atlassian.fugue.Option)description), triggerFromOtherRules, (Option<RunAsUserContextConfig>)StepsConverters.olderOption((io.atlassian.fugue.Option)runAsUserContextConfigOpt), rules, isSystemRuleSet);
            log.debug("New ruleset saved in the database with name: '{}' and id: {}", (Object)name, (Object)createdRuleSetId);
            return createdRuleset;
        });
    }

    private long insertRuleSet(DatabaseConnection connection) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.RULE_SET).setNull(Tables.RULE_SET.ACTIVE_REVISION_ID);
        return this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.RULE_SET.getTableName());
    }

    private long insertRuleSetRevisionAndUpdateActiveRevisionId(@Nonnull DatabaseConnection connection, @Nonnull List<Rule> rules, long ruleSetId, @Nonnull String name, @Nonnull io.atlassian.fugue.Option<String> description, @Nonnull io.atlassian.fugue.Option<RunAsUserContextConfig> runAsUserContext, @Nonnull ProjectContextConfig projectContextConfig, @Nonnull String createdBy, boolean triggerFromOtherRules, boolean isSystemRuleSet) {
        long newRevisionId = this.ruleSetRevisionDao.create(connection, rules, ruleSetId, name, description, runAsUserContext, projectContextConfig, createdBy, triggerFromOtherRules, isSystemRuleSet);
        this.updateActiveRevisionForRuleSet(connection, ruleSetId, newRevisionId);
        return newRevisionId;
    }

    @Override
    @Nonnull
    public Map<Long, RuleSet> getActiveRuleSetsMappedByRuleSetId() {
        List<RuleSetRevisionDao.RuleSetRevision> revisions = this.ruleSetRevisionDao.getActiveRuleSetRevisions();
        return revisions.stream().map(this::createRuleSet).collect(Collectors.collectingAndThen(Collectors.toMap(RuleSet::getId, Function.identity()), Collections::unmodifiableMap));
    }

    private RuleSet createRuleSet(RuleSetRevisionDao.RuleSetRevision ruleSetRevision) {
        return new RuleSetImpl(ruleSetRevision.ruleSetId, ruleSetRevision.id, ruleSetRevision.projectContextConfig, ruleSetRevision.name, (Option<String>)StepsConverters.olderOption(ruleSetRevision.description), ruleSetRevision.triggerFromOtherRules, (Option<RunAsUserContextConfig>)StepsConverters.olderOption(ruleSetRevision.runAsUserContextConfig), ruleSetRevision.rules, ruleSetRevision.isSystemRuleSet);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Option<RuleSet> getActiveRevisionByRuleSetId(long id) {
        log.debug("Retrieving ruleset in the database with id: '{}'", (Object)id);
        SQLQuery selectActiveRevision = (SQLQuery)((SQLQuery)SQLExpressions.select(Tables.RULE_SET.ACTIVE_REVISION_ID).from((Expression)Tables.RULE_SET)).where((Predicate)Tables.RULE_SET.ID.eq((Object)id));
        io.atlassian.fugue.Option<RuleSetRevisionDao.RuleSetRevision> activeRevisionOpt = this.ruleSetRevisionDao.getWhereIdIn((SQLQuery<Long>)selectActiveRevision);
        if (activeRevisionOpt.isEmpty()) {
            log.debug("No active ruleset revision was found for ruleset with id: '{}'", (Object)id);
            return io.atlassian.fugue.Option.none();
        }
        RuleSetRevisionDao.RuleSetRevision activeRevision = (RuleSetRevisionDao.RuleSetRevision)activeRevisionOpt.get();
        RuleSetImpl foundRuleSet = new RuleSetImpl(id, activeRevision.id, activeRevision.projectContextConfig, activeRevision.name, (Option<String>)StepsConverters.olderOption(activeRevision.description), activeRevision.triggerFromOtherRules, (Option<RunAsUserContextConfig>)StepsConverters.olderOption(activeRevision.runAsUserContextConfig), activeRevision.rules, activeRevision.isSystemRuleSet);
        log.debug("Retrieved ruleset in the database with id: '{}', active revision id: '{}' and name: '{}'", new Object[]{id, activeRevision.id, foundRuleSet.getName()});
        return io.atlassian.fugue.Option.some((Object)foundRuleSet);
    }

    @Override
    public io.atlassian.fugue.Option<RuleSet> getRuleSetRevision(long revisionId) {
        io.atlassian.fugue.Option<RuleSetRevisionDao.RuleSetRevision> revisionOpt = this.ruleSetRevisionDao.getRuleSetRevision(revisionId);
        if (revisionOpt.isEmpty()) {
            return io.atlassian.fugue.Option.none();
        }
        RuleSetRevisionDao.RuleSetRevision revision = (RuleSetRevisionDao.RuleSetRevision)revisionOpt.get();
        RuleSet ruleSet = this.createRuleSet(revision);
        return io.atlassian.fugue.Option.some((Object)ruleSet);
    }

    @Override
    public List<Long> getActiveRuleSetIds() {
        log.debug("Retrieving all ruleset ids in the database");
        List allIds = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)connection.select(Tables.RULE_SET.ID).from((Expression)Tables.RULE_SET)).where((Predicate)Tables.RULE_SET.ACTIVE_REVISION_ID.isNotNull())).fetch());
        log.debug("Retrieved all ruleset ids from the database, which were: {}", (Object)allIds);
        return ImmutableList.copyOf((Collection)allIds);
    }

    @Override
    @Nonnull
    public List<Long> getActiveRuleSetRevisionIdsOrderedByRuleSetId() {
        log.debug("Retrieving all ruleset ids in the database");
        List activeRevisionIds = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(Tables.RULE_SET.ACTIVE_REVISION_ID).from((Expression)Tables.RULE_SET)).leftJoin((EntityPath)Tables.RULE_SET_REVISION)).on((Predicate)Tables.RULE_SET.ID.eq(Tables.RULE_SET_REVISION.RULE_SET_ID))).where((Predicate)Tables.RULE_SET.ACTIVE_REVISION_ID.eq(Tables.RULE_SET_REVISION.ID).and((Predicate)Tables.RULE_SET.ACTIVE_REVISION_ID.isNotNull()))).orderBy(Tables.RULE_SET.ID.asc())).fetch());
        log.debug("Retrieved all ruleset ids from the database, which were: {}", (Object)activeRevisionIds);
        return activeRevisionIds;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Option<RuleSet> update(long ruleSetId, @Nonnull String updatedName, @Nonnull io.atlassian.fugue.Option<String> updatedDescription, @Nonnull List<Rule> updatedRules, @Nonnull io.atlassian.fugue.Option<RunAsUserContextConfig> updatedRunAsUserContextConfigOpt, @Nonnull ProjectContextConfig updatedProjectContextConfig, @Nonnull String updatedBy, boolean updatedTriggerFromOtherRules, boolean isSystemRuleSet) {
        Assertions.isTrue((String)"updatedName is required", (boolean)StringUtils.isNotBlank((CharSequence)updatedName));
        Assertions.notNull((String)"updatedDescription is required", updatedDescription);
        Assertions.notNull((String)"updatedRules is required", updatedRules);
        Assertions.notNull((String)"updatedRunAsUserContextConfigOpt is required", updatedRunAsUserContextConfigOpt);
        Assertions.notNull((String)"updatedProjectContextConfig is required", (Object)updatedProjectContextConfig);
        Assertions.isTrue((String)"updatedBy is required", (boolean)StringUtils.isNotBlank((CharSequence)updatedBy));
        return (io.atlassian.fugue.Option)this.databaseAccessor.runInTransaction(connection -> {
            log.debug("Updating ruleset in the database with id: '{}'", (Object)ruleSetId);
            if (this.noRuleSetExistsForId((DatabaseConnection)connection, ruleSetId)) {
                log.debug("An attempt was made to update ruleset with id: {}, but no ruleset with that id exists.", (Object)ruleSetId);
                return io.atlassian.fugue.Option.none();
            }
            long newRevisionId = this.insertRuleSetRevisionAndUpdateActiveRevisionId((DatabaseConnection)connection, updatedRules, ruleSetId, updatedName, updatedDescription, updatedRunAsUserContextConfigOpt, updatedProjectContextConfig, updatedBy, updatedTriggerFromOtherRules, isSystemRuleSet);
            log.debug("Updated ruleset in the database with id: '{}'. Ruleset now has active revision id: '{}'", (Object)ruleSetId, (Object)newRevisionId);
            RuleSetImpl updatedRuleset = new RuleSetImpl(ruleSetId, newRevisionId, updatedProjectContextConfig, updatedName, (Option<String>)StepsConverters.olderOption((io.atlassian.fugue.Option)updatedDescription), updatedTriggerFromOtherRules, (Option<RunAsUserContextConfig>)StepsConverters.olderOption((io.atlassian.fugue.Option)updatedRunAsUserContextConfigOpt), updatedRules, isSystemRuleSet);
            return io.atlassian.fugue.Option.some((Object)updatedRuleset);
        });
    }

    private boolean noRuleSetExistsForId(DatabaseConnection toCheckWith, long ruleSetId) {
        return (Long)((SQLQuery)((SQLQuery)toCheckWith.select((Expression)Tables.RULE_SET.count()).from((Expression)Tables.RULE_SET)).where((Predicate)Tables.RULE_SET.ID.eq((Object)ruleSetId))).fetchOne() == 0L;
    }

    private void updateActiveRevisionForRuleSet(DatabaseConnection toUpdateWith, long idOfRuleSetToUpdate, long newActiveRevisionId) {
        SQLUpdateClause updateClause = toUpdateWith.update((RelationalPath)Tables.RULE_SET).where((Predicate)Tables.RULE_SET.ID.eq((Object)idOfRuleSetToUpdate)).set(Tables.RULE_SET.ACTIVE_REVISION_ID, (Object)newActiveRevisionId);
        this.helper.executeExpectingNRowUpdates(updateClause, 1L, "Error when updating active revision id for ruleset with id: '" + idOfRuleSetToUpdate + "'");
    }

    @Override
    public void delete(long id) {
        log.debug("Deleting ruleset in the database with id: '{}' (setting its active revision id to null)", (Object)id);
        this.databaseAccessor.run(connection -> connection.update((RelationalPath)Tables.RULE_SET).where((Predicate)Tables.RULE_SET.ID.eq((Object)id)).setNull(Tables.RULE_SET.ACTIVE_REVISION_ID).execute());
    }

    @Override
    public io.atlassian.fugue.Option<String> getLastUpdatedUsernameForRuleSet(long ruleSetId) {
        log.debug("Retrieving the last updated username for ruleset with id: '{}'", (Object)ruleSetId);
        String lastUpdatedUsername = (String)this.databaseAccessor.run(connection -> (String)((SQLQuery)((SQLQuery)connection.select((Expression)Tables.RULE_SET_REVISION.CREATED_BY).from((Expression)Tables.RULE_SET_REVISION)).where((Predicate)Tables.RULE_SET_REVISION.ID.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(Tables.RULE_SET.ACTIVE_REVISION_ID).from((Expression)Tables.RULE_SET)).where((Predicate)Tables.RULE_SET.ID.eq((Object)ruleSetId))))).fetchOne());
        if (lastUpdatedUsername != null) {
            log.debug("Retrieving the last updated username for ruleset with id: '{}', which was '{}'", (Object)ruleSetId, (Object)lastUpdatedUsername);
            return io.atlassian.fugue.Option.some((Object)lastUpdatedUsername);
        }
        log.debug("Unable to retrieve the last updated username for ruleset with id: '{}'", (Object)ruleSetId);
        return io.atlassian.fugue.Option.none(String.class);
    }
}

