/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfThen;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QRule;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.WhenImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.IfThenDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.WhenHandlerConfigDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.store.ConfigurationProcessorManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

final class RuleDao
extends QueryDslDao {
    private final WhenHandlerConfigDao whenHandlerConfigDao;
    private final IfThenDao ifThenDao;
    private final ConfigurationProcessorManager configurationProcessorManager;

    RuleDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper, ConfigurationProcessorManager configurationProcessorManager) {
        super(databaseAccessor, helper);
        this.configurationProcessorManager = configurationProcessorManager;
        this.whenHandlerConfigDao = new WhenHandlerConfigDao(databaseAccessor, helper, configurationProcessorManager);
        this.ifThenDao = new IfThenDao(databaseAccessor, helper, this.configurationProcessorManager);
    }

    long create(@Nonnull DatabaseConnection connection, @Nonnull Rule rule, long ruleSetRevisionId, int ordinal) {
        Assertions.notNull((String)"connection is required", (Object)connection);
        Assertions.notNull((String)"rule is required", (Object)rule);
        Assertions.isTrue((String)"ordinal cannot be negative", (ordinal >= 0 ? 1 : 0) != 0);
        long createdRuleId = this.insertRule(connection, ruleSetRevisionId, ordinal, rule.isEnabled());
        this.insertWhenHandlerConfigs(connection, rule.getWhen().getWhenHandlerConfigurations(), createdRuleId);
        this.insertIfThens(connection, rule.getIfThens(), createdRuleId);
        return createdRuleId;
    }

    private long insertRule(DatabaseConnection connection, long ruleSetRevisionId, int ordinal, boolean enabled) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.RULE).set(Tables.RULE.RULESET_REVISION_ID, (Object)ruleSetRevisionId).set(Tables.RULE.ORDINAL, (Object)ordinal).set((Path)Tables.RULE.ENABLED, (Object)enabled);
        return this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.RULE.getTableName());
    }

    private void insertWhenHandlerConfigs(DatabaseConnection connection, List<WhenHandlerConfiguration> whenHandlerConfigs, long idOfAttachedRule) {
        for (int whenHandlerConfigIndex = 0; whenHandlerConfigIndex < whenHandlerConfigs.size(); ++whenHandlerConfigIndex) {
            this.whenHandlerConfigDao.create(connection, idOfAttachedRule, whenHandlerConfigs.get(whenHandlerConfigIndex), whenHandlerConfigIndex + 0);
        }
    }

    private void insertIfThens(DatabaseConnection connection, List<IfThen> ifThens, long idOfAttachedRule) {
        for (int ifThenIndex = 0; ifThenIndex < ifThens.size(); ++ifThenIndex) {
            this.ifThenDao.create(connection, idOfAttachedRule, ifThenIndex + 0, ifThens.get(ifThenIndex));
        }
    }

    public Map<Long, List<Rule>> getForRuleSetRevisionIds(List<Long> ruleSetRevisionIds) {
        Map<Long, List<WhenHandlerConfiguration>> whenHandlerConfigs = this.whenHandlerConfigDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        Map<Long, List<IfThen>> ifThens = this.ifThenDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        Stream<Map> rowStream = Lists.partition(ruleSetRevisionIds, (int)1000).stream().flatMap(ids -> ((List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRule.Row.class, Tables.RULE)).from((Expression)Tables.RULE)).where((Predicate)Tables.RULE.RULESET_REVISION_ID.in((Collection)ids))).fetch())).stream());
        return rowStream.collect(Collectors.collectingAndThen(Collectors.groupingBy(row -> row.rulesetRevisionId, Collectors.mapping(row -> this.createRule((QRule.Row)row, (List)whenHandlerConfigs.get(row.id), (List)ifThens.get(row.id)), Collectors.toList())), Collections::unmodifiableMap));
    }

    private Rule createRule(QRule.Row ruleDbRow, List<WhenHandlerConfiguration> whenHandlerConfig, List<IfThen> ifThen) {
        return new RuleImpl(ruleDbRow.id, new WhenImpl(whenHandlerConfig == null ? Collections.emptyList() : whenHandlerConfig), ifThen == null ? Collections.emptyList() : ifThen, ruleDbRow.enabled);
    }

    Option<Rule> getRuleForId(long ruleId) {
        List returnedRows = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRule.Row.class, Tables.RULE)).from((Expression)Tables.RULE)).where((Predicate)Tables.RULE.ID.eq((Object)ruleId))).fetch());
        if (returnedRows.isEmpty()) {
            return Option.none();
        }
        return Option.some((Object)this.loadRuleFromDbRow((QRule.Row)returnedRows.get(0)));
    }

    List<Rule> getAllForRuleSetRevisionWithId(long ruleSetRevisionId) {
        List returnedRows = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRule.Row.class, Tables.RULE)).from((Expression)Tables.RULE)).where((Predicate)Tables.RULE.RULESET_REVISION_ID.eq((Object)ruleSetRevisionId))).fetch());
        if (returnedRows.isEmpty()) {
            return ImmutableList.of();
        }
        return this.loadRulesFromDbRows(returnedRows);
    }

    private List<Rule> loadRulesFromDbRows(List<QRule.Row> dbRows) {
        ImmutableList.Builder loadedRules = ImmutableList.builder();
        for (QRule.Row ruleRow : dbRows) {
            loadedRules.add((Object)this.loadRuleFromDbRow(ruleRow));
        }
        return loadedRules.build();
    }

    private Rule loadRuleFromDbRow(QRule.Row ruleDbRow) {
        List<WhenHandlerConfiguration> whenHandlerConfigsForRule = this.whenHandlerConfigDao.getAllForRuleWithId(ruleDbRow.id);
        List<IfThen> ifThensForRule = this.ifThenDao.getAllForRuleWithId(ruleDbRow.id);
        return new RuleImpl(ruleDbRow.id, new WhenImpl(whenHandlerConfigsForRule), ifThensForRule, ruleDbRow.enabled);
    }
}

