/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QIfConditionConfig;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ConfigurationDataImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ProcessedComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.IfConditionConfigDataDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.store.ConfigurationProcessorManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

final class IfConditionConfigDao
extends QueryDslDao {
    private final IfConditionConfigDataDao configDataDao;
    private final ConfigurationProcessorManager configurationProcessorManager;

    IfConditionConfigDao(DatabaseAccessor queryFactory, QueryDslDaoHelper helper, ConfigurationProcessorManager configurationProcessorManager) {
        super(queryFactory, helper);
        this.configurationProcessorManager = configurationProcessorManager;
        this.configDataDao = new IfConditionConfigDataDao(queryFactory, helper);
    }

    long create(@Nonnull DatabaseConnection connection, long ifThenId, @Nonnull IfConditionConfiguration ifConditionConfig, int ordinal) {
        Assertions.notNull((String)"connection is required", (Object)connection);
        Assertions.notNull((String)"ifConditionConfig is required", (Object)ifConditionConfig);
        Assertions.isTrue((String)"ordinal cannot be negative", (ordinal >= 0 ? 1 : 0) != 0);
        long createdIfConditionConfigId = this.insertIfConditionConfig(connection, ifThenId, ifConditionConfig, ordinal);
        ConfigurationData convertedConfigData = this.configurationProcessorManager.preStore(ifConditionConfig);
        this.configDataDao.create(connection, createdIfConditionConfigId, convertedConfigData);
        return createdIfConditionConfigId;
    }

    private long insertIfConditionConfig(DatabaseConnection connection, long ifThenId, IfConditionConfiguration ifConditionConfig, int ordinal) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.IF_CONDITION_CONFIG).set(Tables.IF_CONDITION_CONFIG.IF_THEN_ID, (Object)ifThenId).set((Path)Tables.IF_CONDITION_CONFIG.MODULE_KEY, (Object)ifConditionConfig.getModuleKey()).set(Tables.IF_CONDITION_CONFIG.ORDINAL, (Object)ordinal);
        return this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.IF_CONDITION_CONFIG.getTableName());
    }

    Map<Long, List<IfConditionConfiguration>> getForRuleSetRevisionIds(List<Long> ruleSetRevisionIds) {
        Map<Long, ConfigurationData> config = this.configDataDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        Stream<Map> rowStream = Lists.partition(ruleSetRevisionIds, (int)1000).stream().flatMap(ids -> ((List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QIfConditionConfig.Row.class, Tables.IF_CONDITION_CONFIG)).from((Expression)Tables.IF_CONDITION_CONFIG)).join((EntityPath)Tables.IF_THEN)).on((Predicate)Tables.IF_THEN.ID.eq(Tables.IF_CONDITION_CONFIG.IF_THEN_ID))).join((EntityPath)Tables.RULE)).on((Predicate)Tables.RULE.ID.eq(Tables.IF_THEN.RULE_ID))).where((Predicate)Tables.RULE.RULESET_REVISION_ID.in((Collection)ids))).orderBy(Tables.IF_CONDITION_CONFIG.ORDINAL.asc())).fetch())).stream());
        return rowStream.collect(Collectors.collectingAndThen(Collectors.groupingBy(row -> row.ifThenId, Collectors.mapping(row -> this.createIfConditionConfiguration((QIfConditionConfig.Row)row, (ConfigurationData)config.get(row.id)), Collectors.toList())), Collections::unmodifiableMap));
    }

    private IfConditionConfiguration createIfConditionConfiguration(QIfConditionConfig.Row row, ConfigurationData config) {
        return new ProcessedComponentConfigurationImpl(row.id, row.moduleKey, config == null ? ConfigurationDataImpl.EMPTY_INSTANCE : config, this.configurationProcessorManager);
    }

    List<IfConditionConfiguration> getAllForIfThenWithId(long ifThenId) {
        List returnedRows = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QIfConditionConfig.Row.class, Tables.IF_CONDITION_CONFIG)).from((Expression)Tables.IF_CONDITION_CONFIG)).where((Predicate)Tables.IF_CONDITION_CONFIG.IF_THEN_ID.eq((Object)ifThenId))).orderBy(Tables.IF_CONDITION_CONFIG.ORDINAL.asc())).fetch());
        if (returnedRows.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadIfConditionConfigsFromDbRows(returnedRows);
    }

    private List<IfConditionConfiguration> loadIfConditionConfigsFromDbRows(List<QIfConditionConfig.Row> dbRows) {
        ImmutableList.Builder loadedIfConditionConfigs = ImmutableList.builder();
        for (QIfConditionConfig.Row row : dbRows) {
            loadedIfConditionConfigs.add((Object)this.loadIfConditionConfigFromDbRow(row));
        }
        return loadedIfConditionConfigs.build();
    }

    private IfConditionConfiguration loadIfConditionConfigFromDbRow(QIfConditionConfig.Row ifCondConfigRow) {
        ConfigurationData configDataForIfConditionConfig = this.configDataDao.getForIfConditionConfigWithId(ifCondConfigRow.id);
        return new ProcessedComponentConfigurationImpl(ifCondConfigRow.id, ifCondConfigRow.moduleKey, configDataForIfConditionConfig, this.configurationProcessorManager);
    }
}

