/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSetService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputValidationService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidatedRuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationOutcome;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.PermissionCheckFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlags;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.InternalRuleSetProjectContextConfigService;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleSetManager;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.ValidatedRuleSetImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.project.ProjectContextImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.BlueprintManager;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import com.atlassian.util.concurrent.Assertions;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RuleSetServiceImpl
implements RuleSetService {
    private final InternalRuleSetProjectContextConfigService ruleSetProjectContextService;
    private final RuleSetManager ruleSetManager;
    private final AutomationPermissionManager automationPermissionManager;
    private final BlueprintManager blueprintManager;
    private final RuleSetInputValidationService ruleSetInputValidationService;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public RuleSetServiceImpl(@Nonnull InternalRuleSetProjectContextConfigService ruleSetProjectContextService, @Nonnull RuleSetManager ruleSetManager, @Nonnull AutomationPermissionManager automationPermissionManager, @Nonnull BlueprintManager blueprintManager, @Nonnull RuleSetInputValidationService ruleSetInputValidationService, @Nonnull ErrorResultHelper errorResultHelper) {
        this.ruleSetProjectContextService = ruleSetProjectContextService;
        this.ruleSetManager = ruleSetManager;
        this.automationPermissionManager = automationPermissionManager;
        this.blueprintManager = blueprintManager;
        this.ruleSetInputValidationService = ruleSetInputValidationService;
        this.errorResultHelper = errorResultHelper;
    }

    @Nonnull
    public Either<AnError, RuleSet> create(@Nonnull ApplicationUser user, @Nonnull ValidatedRuleSet validatedRuleSet, @Nonnull ServiceFlags flags) {
        Either<AnError, Unit> permissionCheck;
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"validatedRuleSet", (Object)validatedRuleSet);
        Assertions.notNull((String)"flags", (Object)flags);
        if (((PermissionCheckFlag)flags.get(PermissionCheckFlag.class, (ServiceFlag)PermissionCheckFlag.PERFORM_PERMISSION_CHECK)).isPerformPermissionCheck() && (permissionCheck = this.checkManagePermission(user, validatedRuleSet)).isLeft()) {
            return Either.left((Object)permissionCheck.left().get());
        }
        return StepsConverters.olderEither(this.ruleSetManager.create(validatedRuleSet, user.getUsername()));
    }

    public Either<AnError, RuleSet> create(@Nonnull ApplicationUser user, @Nonnull ValidatedRuleSet validatedRuleSet) {
        return this.create(user, validatedRuleSet, ServiceFlags.NONE);
    }

    @Nonnull
    public Either<AnError, RuleSet> getById(@Nonnull Option<ApplicationUser> userOpt, long ruleSetId, @Nonnull ServiceFlags flags) {
        Assertions.notNull((String)"userOpt", userOpt);
        Assertions.notNull((String)"flags", (Object)flags);
        Either ruleSet = StepsConverters.olderEither(this.ruleSetManager.getById(ruleSetId));
        if (ruleSet.isLeft()) {
            return ruleSet;
        }
        if (((PermissionCheckFlag)flags.get(PermissionCheckFlag.class, (ServiceFlag)PermissionCheckFlag.PERFORM_PERMISSION_CHECK)).isPerformPermissionCheck()) {
            this.validateUser(userOpt);
            Either<AnError, Unit> permissionCheck = this.checkViewPermission((ApplicationUser)userOpt.get(), (RuleSet)ruleSet.right().get());
            if (permissionCheck.isLeft()) {
                return ServiceResult.error(permissionCheck);
            }
        }
        return ruleSet;
    }

    public Either<AnError, RuleSet> getById(@Nonnull ApplicationUser user, long ruleSetId) {
        return this.getById((Option<ApplicationUser>)Option.some((Object)user), ruleSetId, ServiceFlags.NONE);
    }

    @Nonnull
    public Either<AnError, List<RuleSet>> getActiveRuleSetsByProject(@Nonnull Option<ApplicationUser> userOpt, @Nonnull Project project, @Nonnull ServiceFlags flags) {
        Assertions.notNull((String)"userOpt", userOpt);
        Assertions.notNull((String)"project", (Object)project);
        Assertions.notNull((String)"flags", (Object)flags);
        if (((PermissionCheckFlag)flags.get(PermissionCheckFlag.class, (ServiceFlag)PermissionCheckFlag.PERFORM_PERMISSION_CHECK)).isPerformPermissionCheck()) {
            this.validateUser(userOpt);
            Either<AnError, Unit> permissionCheck = this.checkViewPermission((ApplicationUser)userOpt.get(), new ProjectContextImpl(project));
            if (permissionCheck.isLeft()) {
                return ServiceResult.error(permissionCheck);
            }
        }
        return Either.right(this.ruleSetManager.getActiveRuleSetsByProject(project));
    }

    public Either<AnError, List<RuleSet>> getActiveRuleSetsByProject(@Nonnull ApplicationUser user, @Nonnull Project project) {
        return this.getActiveRuleSetsByProject((Option<ApplicationUser>)Option.some((Object)user), project, ServiceFlags.NONE);
    }

    @Nonnull
    public Either<AnError, RuleSet> update(@Nonnull ApplicationUser user, long idOfRuleSetToUpdate, @Nonnull ValidatedRuleSet updatedConfig, @Nonnull Option<Long> fromRevisionId, @Nonnull ServiceFlags flags) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"updatedConfig", (Object)updatedConfig);
        Assertions.notNull((String)"fromRevisionId", fromRevisionId);
        Assertions.notNull((String)"flags", (Object)flags);
        Either<AnError, RuleSet> ruleSetPermissionCheck = this.getRuleSetAndRunPermissionChecks(user, idOfRuleSetToUpdate, updatedConfig, flags);
        if (ruleSetPermissionCheck.isLeft()) {
            return ServiceResult.error(ruleSetPermissionCheck);
        }
        RuleSet beforeUpdate = (RuleSet)ruleSetPermissionCheck.right().get();
        return StepsConverters.olderEither(this.ruleSetManager.update(beforeUpdate, updatedConfig, user.getUsername(), (io.atlassian.fugue.Option<Long>)StepsConverters.newerOption(fromRevisionId)));
    }

    public Either<AnError, RuleSet> update(@Nonnull ApplicationUser user, long idOfRuleSetToUpdate, @Nonnull ValidatedRuleSet updatedConfig, @Nonnull Option<Long> fromRevisionId) {
        return this.update(user, idOfRuleSetToUpdate, updatedConfig, fromRevisionId, ServiceFlags.NONE);
    }

    @Nonnull
    public Either<AnError, Unit> delete(@Nonnull Option<ApplicationUser> userOpt, @Nonnull RuleSet ruleSet, @Nonnull ServiceFlags flags) {
        Assertions.notNull((String)"userOpt", userOpt);
        Assertions.notNull((String)"ruleSet", (Object)ruleSet);
        Assertions.notNull((String)"flags", (Object)flags);
        if (((PermissionCheckFlag)flags.get(PermissionCheckFlag.class, (ServiceFlag)PermissionCheckFlag.PERFORM_PERMISSION_CHECK)).isPerformPermissionCheck()) {
            this.validateUser(userOpt);
            Either<AnError, Unit> existingPermissionCheck = this.checkManagePermission((ApplicationUser)userOpt.get(), ruleSet);
            if (existingPermissionCheck.isLeft()) {
                return ServiceResult.error(existingPermissionCheck);
            }
        }
        this.ruleSetManager.delete(ruleSet.getId());
        return Either.right((Object)Unit.UNIT);
    }

    public Either<AnError, Unit> delete(@Nonnull ApplicationUser user, @Nonnull RuleSet ruleSet) {
        return this.delete((Option<ApplicationUser>)Option.some((Object)user), ruleSet, ServiceFlags.NONE);
    }

    private Either<AnError, RuleSet> getRuleSetAndRunPermissionChecks(ApplicationUser toCheckFor, long idOfRuleSetToUpdate, ValidatedRuleSet updatedConfig, ServiceFlags flags) {
        Option<AnError> permissionError;
        Either ruleSetExistsCheck = StepsConverters.olderEither(this.ruleSetManager.getById(idOfRuleSetToUpdate));
        if (ruleSetExistsCheck.isLeft()) {
            return ServiceResult.error((Either)ruleSetExistsCheck);
        }
        RuleSet beforeUpdate = (RuleSet)ruleSetExistsCheck.right().get();
        if (((PermissionCheckFlag)flags.get(PermissionCheckFlag.class, (ServiceFlag)PermissionCheckFlag.PERFORM_PERMISSION_CHECK)).isPerformPermissionCheck() && (permissionError = this.checkForPermissionErrors(toCheckFor, beforeUpdate, updatedConfig)).isDefined()) {
            return ServiceResult.error((AnError)((AnError)permissionError.get()));
        }
        return ServiceResult.ok((Object)beforeUpdate);
    }

    private Option<AnError> checkForPermissionErrors(ApplicationUser toCheckFor, RuleSet beforeUpdate, ValidatedRuleSet updatedConfig) {
        Option preUpdatePermissionError = this.checkManagePermission(toCheckFor, beforeUpdate).left().toOption();
        if (preUpdatePermissionError.isDefined()) {
            return preUpdatePermissionError;
        }
        return this.checkManagePermission(toCheckFor, updatedConfig).left().toOption();
    }

    private Either<AnError, Unit> checkManagePermission(@Nonnull ApplicationUser user, @Nonnull ValidatedRuleSet validatedRuleSet) {
        ValidatedRuleSetImpl validatedRuleSetImpl = (ValidatedRuleSetImpl)validatedRuleSet;
        return this.checkManagePermission(user, validatedRuleSetImpl.getProjectContext());
    }

    private Either<AnError, Unit> checkViewPermission(@Nonnull ApplicationUser user, @Nonnull RuleSet ruleSet) {
        Either projectContext = StepsConverters.olderEither(this.ruleSetProjectContextService.getProjectContext(ruleSet));
        if (projectContext.isRight()) {
            return this.checkViewPermission(user, (ProjectContext)projectContext.right().get());
        }
        return Either.left((Object)projectContext.left().get());
    }

    private Either<AnError, Unit> checkManagePermission(@Nonnull ApplicationUser user, RuleSet ruleSet) {
        Either projectContext = StepsConverters.olderEither(this.ruleSetProjectContextService.getProjectContext(ruleSet));
        if (projectContext.isRight()) {
            return this.checkManagePermission(user, (ProjectContext)projectContext.right().get());
        }
        return Either.left((Object)projectContext.left().get());
    }

    private Either<AnError, Unit> checkViewPermission(ApplicationUser user, @Nonnull ProjectContext projectContext) {
        boolean hasViewRuleSetPermission = this.automationPermissionManager.hasViewRuleSetPermission(user, (io.atlassian.fugue.Option<ProjectContext>)StepsConverters.newerOption((Option)Option.some((Object)projectContext)));
        return StepsConverters.olderEither(this.automationPermissionManager.toEither(user, hasViewRuleSetPermission));
    }

    private Either<AnError, Unit> checkManagePermission(@Nonnull ApplicationUser user, @Nonnull ProjectContext projectContext) {
        boolean hasManageRuleSetPermission = this.automationPermissionManager.hasManageRuleSetPermission(user, (io.atlassian.fugue.Option<ProjectContext>)StepsConverters.newerOption((Option)Option.some((Object)projectContext)));
        return StepsConverters.olderEither(this.automationPermissionManager.toEither(user, hasManageRuleSetPermission));
    }

    public Option<AnError> checkActiveRevisionForRuleSet(@Nonnull Option<ApplicationUser> userOpt, @Nonnull RuleSet toCheckFor, long expectedActiveRevisionId, @Nonnull ServiceFlags flags) {
        Assertions.notNull((String)"userOpt", userOpt);
        Assertions.notNull((String)"toCheckFor", (Object)toCheckFor);
        Assertions.notNull((String)"flags", (Object)flags);
        if (((PermissionCheckFlag)flags.get(PermissionCheckFlag.class, (ServiceFlag)PermissionCheckFlag.PERFORM_PERMISSION_CHECK)).isPerformPermissionCheck()) {
            this.validateUser(userOpt);
            Either<AnError, Unit> permissionCheck = this.checkViewPermission((ApplicationUser)userOpt.get(), toCheckFor);
            if (permissionCheck.isLeft()) {
                return Option.some((Object)permissionCheck.left().get());
            }
        }
        return StepsConverters.olderOption(this.ruleSetManager.checkActiveRevisionForRuleSet(toCheckFor, expectedActiveRevisionId));
    }

    public Option<AnError> checkActiveRevisionForRuleSet(@Nonnull ApplicationUser user, @Nonnull RuleSet toCheckFor, long expectedActiveRevisionId) {
        return this.checkActiveRevisionForRuleSet((Option<ApplicationUser>)Option.some((Object)user), toCheckFor, expectedActiveRevisionId, ServiceFlags.NONE);
    }

    private void validateUser(Option<ApplicationUser> userOpt) {
        Assertions.isTrue((String)"userOpt must be defined for permission checking", (boolean)userOpt.isDefined());
    }

    public Either<AnError, RuleSet> create(@Nonnull ApplicationUser user, @Nonnull Project project, @Nonnull String blueprintModuleKey, @Nonnull ServiceFlags flags) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"project", (Object)project);
        Assertions.notNull((String)"blueprintModuleKey", (Object)blueprintModuleKey);
        Assertions.notNull((String)"flags", (Object)flags);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin(this.blueprintManager.generateRuleSetInput(user, blueprintModuleKey, new ProjectContextImpl(project))).then(ruleSetInput -> StepsConverters.newerEither((Either)this.ruleSetInputValidationService.validate(user, ruleSetInput))).then((ruleSetInput, validationOutcome) -> StepsConverters.newerEither(this.getValidatedRuleSet(blueprintModuleKey, (ValidationOutcome)validationOutcome))).then((ruleSetInput, validationOutcome, validatedRuleSet) -> StepsConverters.newerEither(this.create(user, (ValidatedRuleSet)validatedRuleSet, flags))).yield((ruleSetInput, validationOutcome, validatedRuleSet, ruleSet) -> ruleSet));
    }

    private Either<AnError, ValidatedRuleSet> getValidatedRuleSet(String blueprintModuleKey, ValidationOutcome validationOutcome) {
        if (validationOutcome.getRuleSetValidationResult().isPassed()) {
            return Either.right((Object)validationOutcome.getValidatedRuleSet().get());
        }
        return Either.left((Object)this.errorResultHelper.badRequest400("sd.automation.rule.set.error.component.validation.failed", new Object[]{blueprintModuleKey}).build());
    }

    public Either<AnError, RuleSet> create(@Nonnull ApplicationUser user, @Nonnull Project project, @Nonnull String blueprintModuleKey) {
        return this.create(user, project, blueprintModuleKey, ServiceFlags.NONE);
    }
}

