/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidatedRuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.ProjectContextConfigImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleSetImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleSetManager;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.RuleSetDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.ValidatedRuleSetImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.project.ProjectContextImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.InternalRuleReference;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.RuleAndRuleSet;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.RuleAndRuleSetImpl;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleSetManagerImpl
implements RuleSetManager {
    private static final String RULESETS_BY_ID = "rulesets-by-id";
    private final RuleSetDao ruleSetDao;
    private final ErrorResultHelper errorHelper;
    private final UserManager jiraUserManger;
    private final I18nHelper i18nHelper;
    private final ProjectManager projectManager;
    private final RequestCache<String, Map<Long, RuleSet>> activeRuleSetCache;

    @Autowired
    public RuleSetManagerImpl(ErrorResultHelper errorHelper, RuleSetDao ruleSetDao, UserManager jiraUserManger, I18nHelper i18nHelper, ProjectManager projectManager, VCacheFactory cacheFactory) {
        this.i18nHelper = i18nHelper;
        this.ruleSetDao = ruleSetDao;
        this.errorHelper = errorHelper;
        this.projectManager = projectManager;
        this.jiraUserManger = jiraUserManger;
        this.activeRuleSetCache = cacheFactory.getRequestCache(this.getClass().getName() + ".activeRuleSetCache");
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RuleSet> create(@Nonnull ValidatedRuleSet validatedRuleSet, String createdByUsername) {
        Assertions.notNull((String)"validatedRuleSet is required", (Object)validatedRuleSet);
        Assertions.isTrue((String)"createdByUsername", (boolean)StringUtils.isNotBlank((String)createdByUsername));
        ValidatedRuleSetImpl impl = (ValidatedRuleSetImpl)validatedRuleSet;
        RuleSet createResult = this.ruleSetDao.create(impl.getName(), impl.getDescription(), impl.getRules(), impl.getRunAsUserContext(), this.convertToConfig(impl.getProjectContext()), createdByUsername, impl.getTriggerFromOtherRules(), impl.isSystemRuleSet());
        this.invalidateActiveRuleSetCache();
        return io.atlassian.fugue.Either.right((Object)createResult);
    }

    private ProjectContextConfig convertToConfig(ProjectContext projectContext) {
        ArrayList<Long> projectIdsInTheContext = new ArrayList<Long>();
        for (Project project : projectContext.getProjects()) {
            projectIdsInTheContext.add(project.getId());
        }
        return new ProjectContextConfigImpl(projectIdsInTheContext);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, RuleSet> getById(long id) {
        Option<RuleSet> ruleSetOpt = this.ruleSetDao.getActiveRevisionByRuleSetId(id);
        if (ruleSetOpt.isEmpty()) {
            return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.NOT_FOUND, "sd.automation.rule.set.error.not.found", new Object[]{id}));
        }
        return io.atlassian.fugue.Either.right((Object)ruleSetOpt.get());
    }

    @Override
    @Nonnull
    public List<RuleSet> getActiveRuleSetsByProject(Project project) {
        return this.getActiveRuleSetsByProjectId(project.getId());
    }

    @Nonnull
    private List<RuleSet> getActiveRuleSetsByProjectId(long projectId) {
        ImmutableList.Builder ruleSetsForProject = ImmutableList.builder();
        for (RuleSet possibleMatch : this.getActiveRuleSetsMappedByRuleSetId().values()) {
            if (!this.ruleSetIsForProject(possibleMatch, projectId)) continue;
            ruleSetsForProject.add((Object)possibleMatch);
        }
        return ruleSetsForProject.build();
    }

    private boolean ruleSetIsForProject(RuleSet ruleSet, long projectId) {
        List ruleSetProjectIds = ((RuleSetImpl)ruleSet).getProjectContextConfig().getProjectIds();
        return ruleSetProjectIds.contains(projectId);
    }

    @Override
    @Nonnull
    public List<RuleSet> getActiveRuleSets() {
        return Collections.unmodifiableList(new ArrayList<RuleSet>(this.getActiveRuleSetsMappedByRuleSetId().values()));
    }

    private Map<Long, RuleSet> getActiveRuleSetsMappedByRuleSetId() {
        return (Map)this.activeRuleSetCache.get((Object)RULESETS_BY_ID, this.ruleSetDao::getActiveRuleSetsMappedByRuleSetId);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, RuleAndRuleSet> loadRuleReference(@Nonnull InternalRuleReference ruleReference) {
        Assertions.notNull((String)"ruleReference is required", (Object)ruleReference);
        long ruleSetId = ruleReference.getRuleSetId();
        RuleSet ruleSet = this.getRuleSetWithRetry(ruleSetId);
        if (ruleSet != null) {
            if (ruleSet.getId() != ruleSetId) {
                return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.rule.set.error.inconsistent.rule.reference", new Object[0]));
            }
            Option ruleOpt = Iterables.findFirst((Iterable)ruleSet.getRules(), rule -> ((RuleImpl)rule).getId() == ruleReference.getRuleId());
            if (ruleOpt.isEmpty()) {
                return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.rule.set.error.inconsistent.rule.reference", new Object[0]));
            }
            RuleAndRuleSetImpl ruleAndRuleSet = new RuleAndRuleSetImpl(ruleSet, (Rule)ruleOpt.get());
            return io.atlassian.fugue.Either.right((Object)ruleAndRuleSet);
        }
        return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.NOT_FOUND, "sd.automation.rule.set.error.not.found", new Object[]{ruleSetId}));
    }

    private RuleSet getRuleSetWithRetry(long ruleSetId) {
        RuleSet ruleSet = this.getActiveRuleSetsMappedByRuleSetId().get(ruleSetId);
        if (ruleSet == null) {
            this.invalidateActiveRuleSetCache();
            ruleSet = this.getActiveRuleSetsMappedByRuleSetId().get(ruleSetId);
        }
        return ruleSet;
    }

    private io.atlassian.fugue.Either<AnError, RuleSet> updateInDb(long ruleSetId, ValidatedRuleSet validatedRuleSet, String updatedByUsername) {
        ValidatedRuleSetImpl impl = (ValidatedRuleSetImpl)validatedRuleSet;
        Option<RuleSet> updateResult = this.ruleSetDao.update(ruleSetId, impl.getName(), impl.getDescription(), impl.getRules(), impl.getRunAsUserContext(), this.convertToConfig(impl.getProjectContext()), updatedByUsername, impl.getTriggerFromOtherRules(), impl.isSystemRuleSet());
        if (updateResult.isDefined()) {
            this.invalidateActiveRuleSetCache();
            return io.atlassian.fugue.Either.right((Object)updateResult.get());
        }
        return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.NOT_FOUND, "sd.automation.rule.set.error.not.found", new Object[]{ruleSetId}));
    }

    @Override
    @Nonnull
    public List<AnError> cleanRulesForDeletedProject(long deletedProjectId) {
        ArrayList<AnError> errors = new ArrayList<AnError>();
        List<RuleSet> rs = this.getActiveRuleSetsByProjectId(deletedProjectId);
        for (RuleSet r : rs) {
            Option<AnError> result = this.removeProjectFromRuleSetOrDeleteRuleSet(r, deletedProjectId);
            if (!result.isDefined()) continue;
            errors.add((AnError)result.get());
        }
        return errors;
    }

    private Option<AnError> removeProjectFromRuleSetOrDeleteRuleSet(@Nonnull RuleSet ruleSet, long deletedProjectId) {
        RuleSetImpl rsi = (RuleSetImpl)ruleSet;
        ProjectContextConfig pCtx = rsi.getProjectContextConfig();
        if (pCtx.isGlobal()) {
            return Option.none();
        }
        LinkedList pids = new LinkedList(pCtx.getProjectIds());
        if (!pids.contains(deletedProjectId)) {
            return Option.none();
        }
        List<Project> projects = pids.stream().filter(pid -> pid != deletedProjectId).map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).filter(project -> project != null).collect(Collectors.toList());
        if (projects.isEmpty()) {
            this.delete(ruleSet.getId());
            return Option.none();
        }
        return this.updateProjectContext(rsi, new ProjectContextImpl(projects));
    }

    private Option<AnError> updateProjectContext(@Nonnull RuleSetImpl ruleSet, @Nonnull ProjectContext updatedProjectContext) {
        ValidatedRuleSetImpl vrs = new ValidatedRuleSetImpl(ruleSet.getRules(), updatedProjectContext, ruleSet.getName(), (Option<RunAsUserContextConfig>)StepsConverters.newerOption(ruleSet.getRunAsUserContext()), (Option<String>)StepsConverters.newerOption(ruleSet.getDescription()), ruleSet.getTriggerFromOtherRules(), ruleSet.isSystemRuleSet());
        io.atlassian.fugue.Either<AnError, RuleSet> result = this.update(ruleSet, vrs, "ProjectDeletedCleanup", (Option<Long>)Option.none());
        return (Option)result.fold(Option::some, v -> Option.none());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RuleSet> update(@Nonnull RuleSet ruleSetToUpdate, @Nonnull ValidatedRuleSet updatedConfig, @Nonnull String updatedByUsername, @Nonnull Option<Long> fromRevisionId) {
        Option<AnError> activeRevisionHasChangedError;
        Assertions.notNull((String)"ruleSetToUpdate", (Object)ruleSetToUpdate);
        Assertions.notNull((String)"updatedConfig is required", (Object)updatedConfig);
        Assertions.isTrue((String)"updatedByUsername cannot be blank", (boolean)StringUtils.isNotBlank((String)updatedByUsername));
        Assertions.notNull((String)"fromRevisionId", fromRevisionId);
        if (fromRevisionId.isDefined() && (activeRevisionHasChangedError = this.checkActiveRevisionForRuleSet(ruleSetToUpdate, (Long)fromRevisionId.get())).isDefined()) {
            return io.atlassian.fugue.Either.left((Object)activeRevisionHasChangedError.get());
        }
        return this.updateInDb(ruleSetToUpdate.getId(), updatedConfig, updatedByUsername);
    }

    @Override
    public void delete(long ruleSetId) {
        Option<RuleSet> ruleSetOption = this.ruleSetDao.getActiveRevisionByRuleSetId(ruleSetId);
        if (ruleSetOption.isDefined()) {
            this.ruleSetDao.delete(ruleSetId);
            this.invalidateActiveRuleSetCache();
        }
    }

    @Override
    public Option<AnError> checkActiveRevisionForRuleSet(RuleSet toCheckFor, long expectedActiveRevisionId) {
        Assertions.notNull((String)"toCheckFor", (Object)toCheckFor);
        if (this.activeRevisionHasChanged(toCheckFor, expectedActiveRevisionId)) {
            Option<String> ruleSetLastUpdatedDisplayName = this.getLastUpdatedDisplayNameFor(toCheckFor);
            return Option.some((Object)this.errorHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.rule.set.error.rule.set.update.active.revision.changed", new Object[]{ruleSetLastUpdatedDisplayName.getOrElse((Object)this.i18nHelper.getText("sd.automation.rule.set.error.rule.set.update.active.revision.changed.default.user"))}).left().get());
        }
        return Option.none();
    }

    private boolean activeRevisionHasChanged(RuleSet toCheckFor, long expectedActiveRevisionId) {
        return expectedActiveRevisionId != toCheckFor.getRevisionId();
    }

    private Option<String> getLastUpdatedDisplayNameFor(RuleSet ruleSetToUpdate) {
        Option<String> lastUpdatedUsername = this.ruleSetDao.getLastUpdatedUsernameForRuleSet(ruleSetToUpdate.getId());
        if (lastUpdatedUsername.isEmpty()) {
            return Option.none();
        }
        ApplicationUser user = this.jiraUserManger.getUserByName((String)lastUpdatedUsername.get());
        if (user == null) {
            return Option.some((Object)lastUpdatedUsername.get());
        }
        return Option.some((Object)user.getDisplayName());
    }

    private void invalidateActiveRuleSetCache() {
        this.activeRuleSetCache.removeAll();
    }
}

