/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset;

import com.atlassian.fugue.Option;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RuleSetImpl
implements RuleSet {
    private final String name;
    private final Option<String> description;
    private final List<Rule> rules;
    private final long ruleSetId;
    private boolean triggerFromOtherRules;
    private final ProjectContextConfig projectContextConfig;
    private final Option<RunAsUserContextConfig> runAsUserContext;
    private final boolean isSystemRuleSet;
    private final long revisionId;

    public RuleSetImpl(long ruleSetId, long revisionId, @Nonnull ProjectContextConfig projectContextConfig, @Nonnull String name, @Nonnull Option<String> description, boolean triggerFromOtherRules, @Nonnull Option<RunAsUserContextConfig> runAsUserContext, @Nonnull List<Rule> rules, boolean isSystemRuleSet) {
        Assertions.notNull((String)"rules is required", rules);
        Assertions.notNull((String)"name is required", (Object)name);
        Assertions.notNull((String)"description is required", description);
        Assertions.notNull((String)"projectContext is required", (Object)projectContextConfig);
        Assertions.notNull((String)"runAsUserContext is required", runAsUserContext);
        this.name = name;
        this.description = description;
        this.rules = ImmutableList.copyOf(rules);
        this.ruleSetId = ruleSetId;
        this.revisionId = revisionId;
        this.triggerFromOtherRules = triggerFromOtherRules;
        this.projectContextConfig = projectContextConfig;
        this.runAsUserContext = runAsUserContext;
        this.isSystemRuleSet = isSystemRuleSet;
    }

    public long getId() {
        return this.ruleSetId;
    }

    public long getRevisionId() {
        return this.revisionId;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Option<String> getDescription() {
        return this.description;
    }

    public boolean getTriggerFromOtherRules() {
        return this.triggerFromOtherRules;
    }

    @Nonnull
    public List<Rule> getRules() {
        return Lists.newArrayList(this.rules);
    }

    public boolean isSystemRuleSet() {
        return this.isSystemRuleSet;
    }

    @Nonnull
    public Option<RunAsUserContextConfig> getRunAsUserContext() {
        return this.runAsUserContext;
    }

    @Nonnull
    public ProjectContextConfig getProjectContextConfig() {
        return this.projectContextConfig;
    }
}

