/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.store.ConfigurationProcessorManager;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.LazyReference;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProcessedComponentConfigurationImpl
extends ComponentConfigurationImpl {
    private final ConfigurationProcessorManager configurationProcessorManager;
    @TenantAware(value=TenancyScope.TENANTED)
    private LazyReference<ConfigurationData> augmentedConfigurationData = new LazyReference<ConfigurationData>(){

        protected ConfigurationData create() throws Exception {
            return ProcessedComponentConfigurationImpl.this.augmentConfiguration();
        }
    };

    public ProcessedComponentConfigurationImpl(long id, String moduleKey, ConfigurationData data, ConfigurationProcessorManager configurationProcessorManager) {
        super(id, moduleKey, data);
        Assertions.notNull((String)"configurationProcessorManager is required", (Object)configurationProcessorManager);
        this.configurationProcessorManager = configurationProcessorManager;
    }

    @Override
    @Nonnull
    public ConfigurationData getData() {
        return (ConfigurationData)this.augmentedConfigurationData.get();
    }

    private ConfigurationData augmentConfiguration() {
        return this.configurationProcessorManager.postLoad(this.data, this.moduleKey);
    }
}

