/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.project;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.InternalRuleSetProjectContextConfigService;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleSetImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleSetInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.project.ProjectContextImpl;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class RuleSetProjectContextConfigServiceImpl
implements InternalRuleSetProjectContextConfigService {
    private final ProjectManager projectManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public RuleSetProjectContextConfigServiceImpl(ProjectManager projectManager, ErrorResultHelper errorResultHelper) {
        this.projectManager = projectManager;
        this.errorResultHelper = errorResultHelper;
    }

    @Nonnull
    public Either<AnError, ProjectContextConfig> getProjectContextConfigForRuleSet(@Nonnull RuleSet ruleSet) {
        RuleSetImpl castedRuleSet = (RuleSetImpl)ruleSet;
        return StepsConverters.olderEither((io.atlassian.fugue.Either)io.atlassian.fugue.Either.right((Object)castedRuleSet.getProjectContextConfig()));
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, ProjectContext> getProjectContext(@Nonnull RuleSet ruleSet) {
        io.atlassian.fugue.Either projectContextConfigEither = StepsConverters.newerEither(this.getProjectContextConfigForRuleSet(ruleSet));
        if (projectContextConfigEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)projectContextConfigEither.left().get());
        }
        ProjectContextConfig projectContextConfig = (ProjectContextConfig)projectContextConfigEither.right().get();
        List projectIds = projectContextConfig.getProjectIds();
        ArrayList projects = Lists.newArrayList();
        for (Long projectId : projectIds) {
            Project projectObj = this.projectManager.getProjectObj(projectId);
            if (projectObj == null) {
                return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "Error retrieving ProjectContext, project '" + projectId + "' does not exist", new Object[0]));
            }
            projects.add(projectObj);
        }
        ProjectContextImpl projectContext = new ProjectContextImpl(projects);
        return io.atlassian.fugue.Either.right((Object)projectContext);
    }

    @Override
    @Nonnull
    public Option<ProjectContext> getProjectContextForInput(@Nonnull RuleSetInput ruleSetInput) {
        RuleSetInputImpl ruleSetInputImpl = (RuleSetInputImpl)ruleSetInput;
        Option<Project> projectOption = ruleSetInputImpl.getRuleMetadata().getRuleMetadataProjectInput().getProject();
        if (projectOption.isEmpty()) {
            return Option.none();
        }
        Project project = (Project)projectOption.get();
        ProjectContextImpl projectContext = new ProjectContextImpl(project);
        return Option.some((Object)projectContext);
    }
}

