/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.project;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.PermissionCheckFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlags;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.ProjectRunAsUserContextConfigManager;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ProjectRunAsUserContextConfigServiceImpl
implements ProjectRunAsUserContextConfigService {
    private final ProjectRunAsUserContextConfigManager projectRunAsUserContextConfigManager;
    private final AutomationPermissionManager automationPermissionManager;

    @Autowired
    public ProjectRunAsUserContextConfigServiceImpl(@Nonnull ProjectRunAsUserContextConfigManager projectRunAsUserContextConfigManager, @Nonnull AutomationPermissionManager automationPermissionManager) {
        this.projectRunAsUserContextConfigManager = projectRunAsUserContextConfigManager;
        this.automationPermissionManager = automationPermissionManager;
    }

    @Nonnull
    public Either<AnError, Option<RunAsUserContextConfig>> getContextConfigForProject(@Nonnull ApplicationUser user, @Nonnull Project project) {
        return this.getContextConfigForProject(user, project, ServiceFlags.NONE);
    }

    @Nonnull
    public Either<AnError, Option<RunAsUserContextConfig>> getContextConfigForProject(@Nonnull ApplicationUser user, @Nonnull Project project, @Nonnull ServiceFlags flags) {
        boolean hasManageRuleSetPermission;
        io.atlassian.fugue.Either<AnError, Unit> permissionEither;
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"project", (Object)project);
        Assertions.notNull((String)"flags", (Object)flags);
        boolean performPermissionCheck = ((PermissionCheckFlag)flags.get(PermissionCheckFlag.class, (ServiceFlag)PermissionCheckFlag.PERFORM_PERMISSION_CHECK)).isPerformPermissionCheck();
        if (performPermissionCheck && (permissionEither = this.automationPermissionManager.toEither(user, hasManageRuleSetPermission = this.automationPermissionManager.hasManageRuleSetPermission(user, project))).isLeft()) {
            return StepsConverters.olderEither((io.atlassian.fugue.Either)io.atlassian.fugue.Either.left((Object)permissionEither.left().get()));
        }
        return StepsConverters.olderEither(this.projectRunAsUserContextConfigManager.getContextConfigForProject(project)).map(StepsConverters::olderOption);
    }

    @Nonnull
    public Either<AnError, Unit> setRunAsUserContextConfigForProject(@Nonnull ApplicationUser user, @Nonnull Project project, @Nonnull RunAsUserContextConfig runAsUserContextConfig) {
        return this.setRunAsUserContextConfigForProject(user, project, runAsUserContextConfig, ServiceFlags.NONE);
    }

    @Nonnull
    public Either<AnError, Unit> setRunAsUserContextConfigForProject(@Nonnull ApplicationUser user, @Nonnull Project project, @Nonnull RunAsUserContextConfig runAsUserContextConfig, @Nonnull ServiceFlags flags) {
        boolean hasManageRuleSetPermission;
        io.atlassian.fugue.Either<AnError, Unit> permissionEither;
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"project", (Object)project);
        Assertions.notNull((String)"runAsUserContextConfig", (Object)runAsUserContextConfig);
        Assertions.notNull((String)"flags", (Object)flags);
        boolean performPermissionCheck = ((PermissionCheckFlag)flags.get(PermissionCheckFlag.class, (ServiceFlag)PermissionCheckFlag.PERFORM_PERMISSION_CHECK)).isPerformPermissionCheck();
        if (performPermissionCheck && (permissionEither = this.automationPermissionManager.toEither(user, hasManageRuleSetPermission = this.automationPermissionManager.hasManageRuleSetPermission(user, project))).isLeft()) {
            return StepsConverters.olderEither(permissionEither);
        }
        return StepsConverters.olderEither(this.projectRunAsUserContextConfigManager.setRunAsUserContextConfigForProject(project, runAsUserContextConfig));
    }

    @Nonnull
    public Either<AnError, Unit> deleteContextConfigForProject(@Nonnull ApplicationUser user, @Nonnull Project project) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"project", (Object)project);
        boolean hasManageRuleSetPermission = this.automationPermissionManager.hasManageRuleSetPermission(user, project);
        io.atlassian.fugue.Either<AnError, Unit> permissionEither = this.automationPermissionManager.toEither(user, hasManageRuleSetPermission);
        if (permissionEither.isLeft()) {
            return StepsConverters.olderEither(permissionEither);
        }
        return StepsConverters.olderEither(this.projectRunAsUserContextConfigManager.deleteContextConfigForProject(project));
    }
}

