/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.project;

import com.atlassian.fugue.Either;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsSpecificUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.ProjectRunAsUserContextConfigManager;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.dao.ProjectUserContextDao;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ProjectRunAsUserContextConfigManagerImpl
implements ProjectRunAsUserContextConfigManager {
    private final ProjectUserContextDao projectUserContextDao;
    private final ErrorResultHelper errorResultHelper;
    private final UserManager userManager;
    private final PermissionManager permissionManager;

    @Autowired
    public ProjectRunAsUserContextConfigManagerImpl(@Nonnull ProjectUserContextDao projectUserContextDao, @Nonnull ErrorResultHelper errorResultHelper, @Nonnull UserManager userManager, @Nonnull PermissionManager permissionManager) {
        this.projectUserContextDao = projectUserContextDao;
        this.errorResultHelper = errorResultHelper;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, Option<RunAsUserContextConfig>> getContextConfigForProject(@Nonnull Project project) {
        Option<RunAsUserContextConfig> contextConfigForProject = this.projectUserContextDao.getContextConfigForProject(project.getId());
        return io.atlassian.fugue.Either.right(contextConfigForProject);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, Unit> setRunAsUserContextConfigForProject(@Nonnull Project project, @Nonnull RunAsUserContextConfig runAsUserContextConfig) {
        io.atlassian.fugue.Either<AnError, Unit> validationResult = this.validateContextConfigForProject(project, runAsUserContextConfig);
        if (validationResult.isLeft()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((AnError)((AnError)validationResult.left().get())));
        }
        this.projectUserContextDao.setRunAsUserContextConfigForProject(project.getId(), runAsUserContextConfig);
        return StepsConverters.newerEither((Either)ServiceResult.ok());
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, Unit> deleteContextConfigForProject(@Nonnull Project project) {
        this.projectUserContextDao.deleteContextConfigForProject(project.getId());
        return StepsConverters.newerEither((Either)ServiceResult.ok());
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, Unit> validateContextConfigForProject(@Nonnull Project project, @Nonnull RunAsUserContextConfig runAsUserContextConfig) {
        if (!runAsUserContextConfig.getType().equals("specificUser")) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.error.run.as.user.project.context.error.invalid.config.type", new Object[0]));
        }
        RunAsSpecificUserContextConfig specificUserConfig = (RunAsSpecificUserContextConfig)runAsUserContextConfig;
        ApplicationUser specificUser = this.userManager.getUserByKey(specificUserConfig.getUserKey());
        if (specificUser == null) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.error.run.as.user.project.context.error.user.not.found", new Object[0]));
        }
        if (!this.userHasBrowseAndEditPermissionsOnProject(project, specificUser)) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.error.run.as.user.project.context.error.specific.user.missing.permission", new Object[0]));
        }
        return StepsConverters.newerEither((Either)ServiceResult.ok());
    }

    private boolean userHasBrowseAndEditPermissionsOnProject(Project project, ApplicationUser user) {
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user) && this.permissionManager.hasPermission(ProjectPermissions.EDIT_ISSUES, project, user);
    }
}

