/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.bootstrap.featureflag;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.featureflag.AutomationFeatureFlagRegistry;
import org.apache.commons.lang.Validate;

public class AutomationFeatureFlagRegistrationUtil {
    public static AutomationFeatureFlagRegistry newFeatureFlagRegistry() {
        return new AutomationFeatureFlagRegistry();
    }

    public static FeatureFlag registerFlag(String featureKey, boolean defaultOn, AutomationFeatureFlagRegistry automationFeatureFlagRegistry) {
        AutomationFeatureFlagRegistrationUtil.validate(featureKey, automationFeatureFlagRegistry);
        FeatureFlag featureFlag = FeatureFlag.featureFlag((String)featureKey).defaultedTo(defaultOn);
        automationFeatureFlagRegistry.addFeatureFlag(featureFlag);
        return featureFlag;
    }

    private static void validate(String featureKey, AutomationFeatureFlagRegistry automationFeatureFlagRegistry) {
        Validate.notNull((Object)featureKey, (String)"FeatureKey must not be null");
        Validate.isTrue((boolean)AutomationFeatureFlagRegistrationUtil.featureKeyDoesNotEndWithPostfix(featureKey), (String)"Invalid feature key provided, key should be of the form 'sd.feature.flag', NOT 'sd.feature.flag.enabled' or 'sd.feature.flag.disabled'");
        Validate.isTrue((boolean)AutomationFeatureFlagRegistrationUtil.featureKeyDoesNotExist(featureKey, automationFeatureFlagRegistry), (String)String.format("Feature key %s already registered", featureKey));
    }

    private static boolean featureKeyDoesNotEndWithPostfix(String featureKey) {
        return !featureKey.endsWith(".enabled") && !featureKey.endsWith(".disabled");
    }

    private static boolean featureKeyDoesNotExist(String featureKey, AutomationFeatureFlagRegistry automationFeatureFlagRegistry) {
        for (FeatureFlag featureFlag : automationFeatureFlagRegistry.getRegisteredFlags()) {
            if (!featureKey.equals(featureFlag.featureKey())) continue;
            return false;
        }
        return true;
    }
}

