/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.bootstrap;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.util.runners.SealedRunner;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.async.AsynchronousExecutionThreadManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.legacy.LegacyAsyncThenJobRunner;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryCleaner;
import com.atlassian.servicedesk.plugins.automation.internal.execution.whenhandler.event.AllEventsListener;
import com.atlassian.servicedesk.plugins.automation.internal.execution.whenhandler.event.ProjectDeletedEventListener;
import com.atlassian.servicedesk.plugins.automation.internal.log.LogLeveller;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class AutomationPluginLauncher
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(AutomationPluginLauncher.class);
    private final EventPublisher eventPublisher;
    private final AllEventsListener allEventsListener;
    private final ProjectDeletedEventListener projectDeletedEventListener;
    private final AsynchronousExecutionThreadManager asynchronousExecutionThreadManager;
    private final LegacyAsyncThenJobRunner asyncThenJobRunner;
    private final ExecutionHistoryCleaner executionHistoryCleaner;
    private static final String PLUGIN_STARTED_EVENT = "plugin.started.event";
    private static final String LIFECYCLE_AWARE_ONSTART = "lifecycle.aware.onstart";
    private static final String PLUGIN_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-plugin";
    private final LazyReference<SealedRunner> sealedStartCompleteRunner = new LazyReference<SealedRunner>(){

        protected SealedRunner create() throws Exception {
            return new SealedRunner((List)ImmutableList.of((Object)AutomationPluginLauncher.PLUGIN_STARTED_EVENT, (Object)AutomationPluginLauncher.LIFECYCLE_AWARE_ONSTART), () -> AutomationPluginLauncher.this.onStartCompleted());
        }
    };

    @Autowired
    public AutomationPluginLauncher(@Nonnull EventPublisher eventPublisher, @Nonnull AllEventsListener allEventsListener, @Nonnull ProjectDeletedEventListener projectDeletedEventListener, @Nonnull AsynchronousExecutionThreadManager asynchronousExecutionThreadManager, @Nonnull LegacyAsyncThenJobRunner asyncThenJobRunner, @Nonnull ExecutionHistoryCleaner executionHistoryCleaner) {
        this.eventPublisher = eventPublisher;
        this.allEventsListener = allEventsListener;
        this.projectDeletedEventListener = projectDeletedEventListener;
        this.asynchronousExecutionThreadManager = asynchronousExecutionThreadManager;
        this.asyncThenJobRunner = asyncThenJobRunner;
        this.executionHistoryCleaner = executionHistoryCleaner;
        LogLeveller.setInfo(log);
    }

    @PostConstruct
    public void onSpringContextStarted() {
        this.eventPublisher.register((Object)this);
    }

    public void onStart() {
        ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(LIFECYCLE_AWARE_ONSTART);
    }

    @EventListener
    public final void onPluginStarted(PluginEnabledEvent pluginEnabledEvent) {
        if (pluginEnabledEvent.getPlugin().getKey().equals(PLUGIN_KEY)) {
            ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(PLUGIN_STARTED_EVENT);
        }
    }

    public void onStartCompleted() {
        log.info("AutomationPlugin onStart() - Service Desk Automation Plugin is starting...");
        this.tenantlessSetup();
        this.tenantedSetup();
        log.info("AutomationPlugin onStart() - Service Desk Automation Plugin is started.");
    }

    public void onStop() {
        log.info("AutomationPlugin onStop() - Service Desk Automation Plugin is stopping...");
        this.tenantedShutdown();
        this.tenantlessShutDown();
        log.info("AutomationPlugin onStop() - Service Desk Automation Plugin is stopped.");
    }

    private void tenantlessSetup() {
        this.allEventsListener.enableEventsProcessing(this.eventPublisher);
        this.asynchronousExecutionThreadManager.register();
        this.asyncThenJobRunner.register();
        this.executionHistoryCleaner.register();
    }

    private void tenantedSetup() {
        log.info("AutomationPlugin - tenantedSetup()");
        this.executionHistoryCleaner.schedule();
    }

    private void tenantlessShutDown() {
        this.executionHistoryCleaner.unregister();
        this.eventPublisher.unregister((Object)this.projectDeletedEventListener);
        this.allEventsListener.disableEventsProcessing(this.eventPublisher);
        this.asynchronousExecutionThreadManager.unregister();
        this.asyncThenJobRunner.unregister();
    }

    private void tenantedShutdown() {
        log.info("AutomationPlugin - tenantedShutdown()");
        this.executionHistoryCleaner.unschedule();
    }
}

