/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen.helper;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.servicedesk.plugins.automation.modules.common.LinkTypeDirection;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.helper.UniqueLinksBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UniqueLinksBuilderImpl
implements UniqueLinksBuilder {
    @TenantAware(value=TenancyScope.TENANTED)
    Map<Issue, Map<IssueLinkType, List<LinkTypeDirection>>> uniqueLinks = new HashMap<Issue, Map<IssueLinkType, List<LinkTypeDirection>>>();

    @Override
    public UniqueLinksBuilder addOrUpdate(Issue incident, IssueLinkType linkType, LinkTypeDirection direction) {
        if (this.uniqueLinks.containsKey(incident)) {
            Map<IssueLinkType, List<LinkTypeDirection>> linkTypeToDirectionMap = this.uniqueLinks.get(incident);
            List<Object> directions = null;
            if (linkTypeToDirectionMap.containsKey(linkType)) {
                directions = linkTypeToDirectionMap.get(linkType);
                directions.add((Object)direction);
            } else {
                directions = new ArrayList();
                directions.add((Object)direction);
                linkTypeToDirectionMap.put(linkType, directions);
            }
        } else {
            HashMap linkTypeToDirectionMap = new HashMap();
            ArrayList<LinkTypeDirection> directions = new ArrayList<LinkTypeDirection>();
            directions.add(direction);
            linkTypeToDirectionMap.put(linkType, directions);
            this.uniqueLinks.put(incident, linkTypeToDirectionMap);
        }
        return this;
    }

    @Override
    public Map<Issue, Map<IssueLinkType, List<LinkTypeDirection>>> build() {
        return new ImmutableMap.Builder().putAll(this.uniqueLinks).build();
    }
}

