/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen.helper;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageCache;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.LinkedIssueMessageHelper;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkedIssueMessageHelperImpl
implements LinkedIssueMessageHelper {
    private static final Logger log = LoggerFactory.getLogger(LinkedIssueMessageHelperImpl.class);
    @VisibleForTesting
    protected static final String LINKED_ISSUEKEY_KEY = "com.automation.linked.issueKey";
    @VisibleForTesting
    protected static final String LINKED_ISSUEID_KEY = "com.automation.linked.issueId";
    @VisibleForTesting
    protected static final String LINKED_ISSUE_CACHE_KEY = "com.automation.linked.issueObject";
    private final IssueManager issueManager;

    @Autowired
    public LinkedIssueMessageHelperImpl(IssueManager issueManager) {
        this.issueManager = issueManager;
    }

    private io.atlassian.fugue.Option<Long> getLinkedIssueId(RuleMessage ruleMessage) {
        return this.getLongFromRuleMessage(ruleMessage, LINKED_ISSUEID_KEY);
    }

    public io.atlassian.fugue.Option<Long> getLongFromRuleMessage(RuleMessage ruleMessage, String dataKey) {
        return StepsConverters.newerOption((Option)ruleMessage.getValue(dataKey)).flatMap(this::convertStringToLong);
    }

    private io.atlassian.fugue.Option<Long> convertStringToLong(String value) {
        try {
            return io.atlassian.fugue.Option.some((Object)Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            log.error("Could not parse string value '" + value + "' to long. Ensure that the value was properly added to the RuleMessage in the corresponding WHEN handler");
            return io.atlassian.fugue.Option.none();
        }
    }

    private io.atlassian.fugue.Option<String> getLinkedIssueKey(RuleMessage ruleMessage) {
        return StepsConverters.newerOption((Option)ruleMessage.getValue(LINKED_ISSUEKEY_KEY));
    }

    @Override
    public boolean linkedIssueIsDefined(RuleMessage ruleMessage) {
        return this.linkedIssueIdIsDefined(ruleMessage) || this.linkedIssueKeyIsDefined(ruleMessage);
    }

    private boolean linkedIssueIdIsDefined(RuleMessage ruleMessage) {
        return this.getLinkedIssueId(ruleMessage).isDefined();
    }

    private boolean linkedIssueKeyIsDefined(RuleMessage ruleMessage) {
        return this.getLinkedIssueKey(ruleMessage).isDefined();
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Issue> getLinkedIssue(RuleMessage ruleMessage) {
        io.atlassian.fugue.Option<Issue> issueOpt = this.getIssueOptionFromCache(ruleMessage);
        if (issueOpt.isDefined()) {
            return io.atlassian.fugue.Either.right((Object)issueOpt.get());
        }
        io.atlassian.fugue.Either<AnError, Issue> issueResult = this.loadIssue(ruleMessage);
        this.updateIssueInCache(ruleMessage, (io.atlassian.fugue.Option<Issue>)issueResult.toOption());
        return issueResult;
    }

    @Override
    public void invalidateLinkedIssue(RuleMessage ruleMessage) {
        this.updateIssueInCache(ruleMessage, (io.atlassian.fugue.Option<Issue>)io.atlassian.fugue.Option.none());
    }

    @Override
    public void setLinkedIssueData(RuleMessageBuilder builder, Issue linkedIssue) {
        builder.putValue(LINKED_ISSUEID_KEY, linkedIssue.getId().toString());
        builder.putValue(LINKED_ISSUEKEY_KEY, linkedIssue.getKey());
    }

    private io.atlassian.fugue.Either<AnError, Issue> loadIssue(RuleMessage ruleMessage) {
        io.atlassian.fugue.Option<Long> issueId = this.getLinkedIssueId(ruleMessage);
        if (issueId.isDefined()) {
            try {
                MutableIssue issueObject = this.issueManager.getIssueObject((Long)issueId.get());
                if (issueObject != null) {
                    return StepsConverters.newerEither((Either)ServiceResult.ok((Object)issueObject));
                }
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"Issue could not be found"));
            }
            catch (DataAccessException e) {
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)e.getMessage()));
            }
        }
        io.atlassian.fugue.Option<String> issueKey = this.getLinkedIssueKey(ruleMessage);
        if (issueKey.isDefined()) {
            try {
                MutableIssue issueObject = this.issueManager.getIssueObject((String)issueKey.get());
                if (issueObject != null) {
                    return StepsConverters.newerEither((Either)ServiceResult.ok((Object)issueObject));
                }
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"Issue could not be found"));
            }
            catch (DataAccessException e) {
                return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)e.getMessage()));
            }
        }
        return StepsConverters.newerEither((Either)ServiceResult.error((int)HttpStatusCode.NOT_FOUND, (String)"No value found for given prefix"));
    }

    private io.atlassian.fugue.Option<Issue> getIssueOptionFromCache(RuleMessage ruleMessage) {
        RuleMessageCache cache = ruleMessage.getCache();
        return StepsConverters.newerOption((Option)cache.get(LINKED_ISSUE_CACHE_KEY)).flatMap(Functions.isInstanceOf(Issue.class));
    }

    private void updateIssueInCache(RuleMessage ruleMessage, io.atlassian.fugue.Option<Issue> issue) {
        RuleMessageCache cache = ruleMessage.getCache();
        if (issue.isEmpty()) {
            cache.remove(LINKED_ISSUE_CACHE_KEY);
            return;
        }
        cache.set(LINKED_ISSUE_CACHE_KEY, issue.get());
    }
}

