/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen.helper;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.ApprovalMessageHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.atlassian.fugue.Option;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ApprovalMessageHelperImpl
implements ApprovalMessageHelper {
    private static final Logger log = LoggerFactory.getLogger(ApprovalMessageHelperImpl.class);
    private static final Gson GSON = new Gson();
    private static final Type GSON_APPROVAL_SET_TYPE = new TypeToken<Set<String>>(){}.getType();
    @VisibleForTesting
    protected static final String NEW_APPROVERS_MESSAGE_KEY = "newApproversKeys";
    private UserManager userManager;

    @Autowired
    public ApprovalMessageHelperImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public void setNewApprovers(RuleMessageBuilder builder, Set<String> newApproverUserKeys) {
        String serializedApprovers = GSON.toJson(newApproverUserKeys);
        builder.putValue(NEW_APPROVERS_MESSAGE_KEY, serializedApprovers);
    }

    @Override
    public Option<Set<ApplicationUser>> getNewApprovers(RuleMessage ruleMessage) {
        return StepsConverters.newerOption((com.atlassian.fugue.Option)ruleMessage.getValue(NEW_APPROVERS_MESSAGE_KEY)).flatMap(this::deserializeJsonSet).map(this::userKeysToApplicationUsers);
    }

    private Option<Set<String>> deserializeJsonSet(String serializedSet) {
        try {
            return Option.some((Object)GSON.fromJson(serializedSet, GSON_APPROVAL_SET_TYPE));
        }
        catch (JsonSyntaxException e) {
            log.error("Could not parse string set '" + serializedSet + "'. Ensure that the value was properly added to the RuleMessage in the corresponding WHEN handler");
            return Option.none();
        }
    }

    private Set<ApplicationUser> userKeysToApplicationUsers(Set<String> userKeys) {
        return userKeys.stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKey(arg_0)).filter(user -> user != null).collect(Collectors.toSet());
    }
}

