/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen;

import com.atlassian.fugue.Either;
import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.user.InContextFunction;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerProjectContextService;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerRunInContextService;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.ServiceDeskCommentCreatedEventWhenHandler;
import io.atlassian.fugue.Option;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhenUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDeskCommentCreatedEventWhenHandler.class);
    private final WhenHandlerProjectContextService whenHandlerProjectContextService;
    private final WhenHandlerRunInContextService whenHandlerRunInContextService;
    private final PermissionManager permissionManager;

    @Autowired
    public WhenUtils(WhenHandlerProjectContextService whenHandlerProjectContextService, WhenHandlerRunInContextService whenHandlerRunInContextService, PermissionManager permissionManager) {
        this.whenHandlerProjectContextService = whenHandlerProjectContextService;
        this.whenHandlerRunInContextService = whenHandlerRunInContextService;
        this.permissionManager = permissionManager;
    }

    boolean matchContextWithPermissionCheck(@Nonnull WhenHandlerContext context, @Nonnull Issue issue) {
        Project project = issue.getProjectObject();
        if (project == null) {
            LOG.error("Could not find project object for issue with ID: " + issue.getId());
            return false;
        }
        return this.isApplicableProject(context, project) && this.canBrowseIssue(context, issue);
    }

    public boolean isApplicableProject(@Nonnull WhenHandlerContext context, @Nonnull Project project) {
        io.atlassian.fugue.Either applicationProjectContext = StepsConverters.newerEither((Either)this.whenHandlerProjectContextService.getApplicationProjectContext(context));
        if (applicationProjectContext.isLeft()) {
            return false;
        }
        List projects = ((ProjectContext)applicationProjectContext.right().get()).getProjects();
        if (projects.isEmpty()) {
            return true;
        }
        return projects.contains(project);
    }

    public boolean canBrowseIssue(@Nonnull WhenHandlerContext context, final @Nonnull Issue issue) {
        return (Boolean)this.whenHandlerRunInContextService.executeInContext(context, (InContextFunction)new InContextFunction<Boolean>(){

            public Boolean run(ApplicationUser user) {
                return WhenUtils.this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user);
            }
        });
    }

    Date retrieveEventTimeOrNow(JiraEvent jiraEvent) {
        return (Date)Option.option((Object)jiraEvent.getTime()).getOrElse((Object)new Date());
    }
}

