/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen;

import com.atlassian.servicedesk.internal.api.events.OrganisationsAddedToIssueEvent;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.EventTimeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.OrganisationParticipantsMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.WhenUtils;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganisationsAddedToIssueEventWhenHandler
implements EventWhenHandler<OrganisationsAddedToIssueEvent> {
    private static final Logger log = LoggerFactory.getLogger(OrganisationsAddedToIssueEventWhenHandler.class);
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final IssueMessageHelper issueMessageHelper;
    private final UserMessageHelper userMessageHelper;
    private final EventTimeMessageHelper eventTimeMessageHelper;
    private final WhenUtils whenUtils;
    private final RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService;

    public OrganisationsAddedToIssueEventWhenHandler(RuleMessageBuilderService ruleMessageBuilderService, IssueMessageHelper issueMessageHelper, UserMessageHelper userMessageHelper, EventTimeMessageHelper eventTimeMessageHelper, WhenUtils whenUtils, RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService) {
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.issueMessageHelper = issueMessageHelper;
        this.userMessageHelper = userMessageHelper;
        this.eventTimeMessageHelper = eventTimeMessageHelper;
        this.whenUtils = whenUtils;
        this.ruleExecutionCommandBuilderService = ruleExecutionCommandBuilderService;
    }

    public Class<OrganisationsAddedToIssueEvent> getEventClass() {
        return OrganisationsAddedToIssueEvent.class;
    }

    public List<RuleExecutionCommand> handleEvent(@Nonnull List<WhenHandlerContext> contexts, @Nonnull OrganisationsAddedToIssueEvent organisationsAddedToIssueEvent) {
        Set addedOrganisationIds = organisationsAddedToIssueEvent.getOrganisationIds();
        if (addedOrganisationIds.isEmpty()) {
            return new ArrayList<RuleExecutionCommand>();
        }
        log.debug("Handling OrganisationParticipantsAddedEvent event. # of contexts found: {}", (Object)contexts.size());
        return this.buildRuleExecutionCommands(contexts, organisationsAddedToIssueEvent, addedOrganisationIds);
    }

    private List<RuleExecutionCommand> buildRuleExecutionCommands(List<WhenHandlerContext> contexts, OrganisationsAddedToIssueEvent organisationsAddedToIssueEvent, Set<Integer> addedOrganisationIds) {
        RuleMessage ruleMessage = this.createRuleMessage(organisationsAddedToIssueEvent, addedOrganisationIds);
        RuleExecutionCommandBuilder builder = this.ruleExecutionCommandBuilderService.builder().ruleMessage(ruleMessage);
        return contexts.stream().filter(context -> this.whenUtils.matchContextWithPermissionCheck((WhenHandlerContext)context, organisationsAddedToIssueEvent.getIssue())).map(context -> builder.ruleReference(context.getRuleReference()).build()).collect(Collectors.toList());
    }

    private RuleMessage createRuleMessage(OrganisationsAddedToIssueEvent organisationsAddedToIssueEvent, Set<Integer> addedOrganisationIds) {
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder();
        Date eventTime = organisationsAddedToIssueEvent.getTime() != null ? organisationsAddedToIssueEvent.getTime() : new Date();
        Option authorOpt = organisationsAddedToIssueEvent.getInitiator();
        authorOpt.forEach(author -> this.userMessageHelper.setUser(builder, "currentUser", author));
        this.issueMessageHelper.setIssueData(builder, organisationsAddedToIssueEvent.getIssue());
        this.eventTimeMessageHelper.setEventTime(builder, eventTime);
        OrganisationParticipantsMessageHelper.setNewOrganisationParticipants(builder, addedOrganisationIds);
        return builder.build();
    }
}

