/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.event.SDLinkedIssueTransitionedEvent;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.modules.common.IssueIndexingHelper;
import com.atlassian.servicedesk.plugins.automation.modules.common.LinkTypeDirection;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.LinkedIssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.LinkTypeIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.WhenUtils;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.helper.UniqueLinksBuilder;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.helper.UniqueLinksBuilderImpl;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedIssueTransitionedEventWhenHandler
implements EventWhenHandler<SDLinkedIssueTransitionedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(LinkedIssueTransitionedEventWhenHandler.class);
    private final WhenUtils whenUtils;
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService;
    private final LinkedIssueMessageHelper linkedIssueMessageHelper;
    private final UserMessageHelper userMessageHelper;
    private final IssueMessageHelper issueMessageHelper;
    private final LinkTypeIfConditionHelper linkTypeIfConditionHelper;
    private final IssueIndexingHelper issueIndexingHelper;

    public LinkedIssueTransitionedEventWhenHandler(@Nonnull WhenUtils whenUtils, @Nonnull RuleMessageBuilderService ruleMessageBuilderService, @Nonnull RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService, @Nonnull LinkedIssueMessageHelper linkedIssueMessageHelper, @Nonnull UserMessageHelper userMessageHelper, @Nonnull IssueMessageHelper issueMessageHelper, @Nonnull LinkTypeIfConditionHelper linkTypeIfConditionHelper, @Nonnull IssueIndexingHelper issueIndexingHelper) {
        this.whenUtils = whenUtils;
        this.ruleExecutionCommandBuilderService = ruleExecutionCommandBuilderService;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.linkedIssueMessageHelper = linkedIssueMessageHelper;
        this.userMessageHelper = userMessageHelper;
        this.issueMessageHelper = issueMessageHelper;
        this.linkTypeIfConditionHelper = linkTypeIfConditionHelper;
        this.issueIndexingHelper = issueIndexingHelper;
    }

    public Class<SDLinkedIssueTransitionedEvent> getEventClass() {
        return SDLinkedIssueTransitionedEvent.class;
    }

    public List<RuleExecutionCommand> handleEvent(@Nonnull List<WhenHandlerContext> contexts, @Nonnull SDLinkedIssueTransitionedEvent event) {
        Issue problem;
        List inwardLinks = event.getInwardLinks();
        List outwardLinks = event.getOutwardLinks();
        if (!inwardLinks.isEmpty()) {
            problem = ((IssueLink)inwardLinks.get(0)).getDestinationObject();
        } else if (!outwardLinks.isEmpty()) {
            problem = ((IssueLink)outwardLinks.get(0)).getSourceObject();
        } else {
            return ImmutableList.of();
        }
        this.issueIndexingHelper.reindexIssue(problem);
        List<RuleExecutionCommand> commands = this.getCommands(contexts, this.filterDuplicatedLinks(inwardLinks, outwardLinks), event.getEventTriggeredUser(), problem);
        return ImmutableList.copyOf(commands);
    }

    @VisibleForTesting
    Map<Issue, Map<IssueLinkType, List<LinkTypeDirection>>> filterDuplicatedLinks(@Nonnull List<IssueLink> inwardLinks, @Nonnull List<IssueLink> outwardLinks) {
        UniqueLinksBuilderImpl uniqueLinksBuilder = new UniqueLinksBuilderImpl();
        this.filterInwardLinks(inwardLinks, uniqueLinksBuilder);
        this.filterOutwardLinks(outwardLinks, uniqueLinksBuilder);
        return uniqueLinksBuilder.build();
    }

    @VisibleForTesting
    void filterInwardLinks(@Nonnull List<IssueLink> inwardLinks, @Nonnull UniqueLinksBuilder builder) {
        for (IssueLink inwardLink : inwardLinks) {
            Issue incident = inwardLink.getSourceObject();
            builder.addOrUpdate(incident, inwardLink.getIssueLinkType(), LinkTypeDirection.Inward);
        }
    }

    @VisibleForTesting
    void filterOutwardLinks(@Nonnull List<IssueLink> outwardLinks, @Nonnull UniqueLinksBuilder builder) {
        for (IssueLink outwardLink : outwardLinks) {
            Issue incident = outwardLink.getDestinationObject();
            builder.addOrUpdate(incident, outwardLink.getIssueLinkType(), LinkTypeDirection.Outward);
        }
    }

    @VisibleForTesting
    List<RuleExecutionCommand> getRuleExecutionCommands(@Nonnull List<WhenHandlerContext> contexts, @Nonnull Issue eventTriggeredIssue, @Nonnull Issue targetingIssue, @Nullable ApplicationUser eventTriggeredUser, @Nonnull Map<IssueLinkType, List<LinkTypeDirection>> issueLinkTypes) {
        RuleMessage message = this.createRuleMessage(eventTriggeredIssue, targetingIssue, eventTriggeredUser, issueLinkTypes);
        RuleExecutionCommandBuilder asynchronousExecutionBuilder = this.ruleExecutionCommandBuilderService.builder().ruleMessage(message);
        ArrayList commands = Lists.newArrayList();
        for (WhenHandlerContext context : contexts) {
            if (!this.matchContext(context, eventTriggeredIssue, targetingIssue, eventTriggeredUser)) continue;
            RuleExecutionCommand command = asynchronousExecutionBuilder.ruleReference(context.getRuleReference()).build();
            commands.add(command);
        }
        return ImmutableList.copyOf((Collection)commands);
    }

    @VisibleForTesting
    boolean matchContext(@Nonnull WhenHandlerContext context, @Nonnull Issue eventTriggeredIssue, @Nonnull Issue targetingIssue, @Nullable ApplicationUser eventTriggeredUser) {
        Project destinationProject = targetingIssue.getProjectObject();
        if (!this.whenUtils.isApplicableProject(context, destinationProject)) {
            LOG.debug("Unable to fetch project context for given when handler context: " + context.toString());
            return false;
        }
        if (!this.whenUtils.canBrowseIssue(context, eventTriggeredIssue) || !this.whenUtils.canBrowseIssue(context, targetingIssue)) {
            String userKey = String.valueOf(Option.option((Object)eventTriggeredUser).map(ApplicationUser::getKey).getOrNull());
            LOG.debug("The user " + userKey + " doesn't have the permission to view the issue " + userKey);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    RuleMessage createRuleMessage(@Nonnull Issue eventTriggeredIssue, @Nonnull Issue targetingIssue, @Nullable ApplicationUser eventTriggeredUser, @Nonnull Map<IssueLinkType, List<LinkTypeDirection>> issueLinkTypes) {
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder();
        this.linkedIssueMessageHelper.setLinkedIssueData(builder, eventTriggeredIssue);
        this.issueMessageHelper.setIssueData(builder, targetingIssue);
        this.linkTypeIfConditionHelper.setLinkTypeData(builder, (Map<IssueLinkType, List<LinkTypeDirection>>)new ImmutableMap.Builder().putAll(issueLinkTypes).build());
        if (eventTriggeredUser != null) {
            this.userMessageHelper.setUser(builder, "currentUser", eventTriggeredUser.getKey());
        }
        return builder.build();
    }

    @VisibleForTesting
    List<RuleExecutionCommand> getCommands(@Nonnull List<WhenHandlerContext> contexts, @Nonnull Map<Issue, Map<IssueLinkType, List<LinkTypeDirection>>> links, @Nullable ApplicationUser eventTriggeredUser, @Nonnull Issue problem) {
        ArrayList commands = Lists.newArrayList();
        for (Map.Entry<Issue, Map<IssueLinkType, List<LinkTypeDirection>>> entry : links.entrySet()) {
            Issue incident = entry.getKey();
            Map<IssueLinkType, List<LinkTypeDirection>> linkTypes = entry.getValue();
            List<RuleExecutionCommand> ruleExecutionCommands = this.getRuleExecutionCommands(contexts, problem, incident, eventTriggeredUser, linkTypes);
            commands.addAll(ruleExecutionCommands);
        }
        return commands;
    }
}

