/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.EventTimeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.WhenUtils;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IssueCreatedEventWhenHandler
implements EventWhenHandler<IssueEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(IssueCreatedEventWhenHandler.class);
    private final IssueMessageHelper issueMessageHelper;
    private final UserMessageHelper userMessageHelper;
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final EventTimeMessageHelper eventTimeMessageHelper;
    private final RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService;
    private final WhenUtils whenUtils;
    private final IssueEventHelper issueEventHelper;

    public IssueCreatedEventWhenHandler(IssueMessageHelper issueMessageHelper, UserMessageHelper userMessageHelper, EventTimeMessageHelper eventTimeMessageHelper, RuleMessageBuilderService ruleMessageBuilderService, RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService, WhenUtils whenUtils, IssueEventHelper issueEventHelper) {
        this.userMessageHelper = userMessageHelper;
        this.eventTimeMessageHelper = eventTimeMessageHelper;
        this.ruleExecutionCommandBuilderService = ruleExecutionCommandBuilderService;
        this.issueMessageHelper = issueMessageHelper;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.whenUtils = whenUtils;
        this.issueEventHelper = issueEventHelper;
    }

    public Class<IssueEvent> getEventClass() {
        return IssueEvent.class;
    }

    public List<RuleExecutionCommand> handleEvent(@Nonnull List<WhenHandlerContext> contexts, @Nonnull IssueEvent event) {
        if (!this.isCreatedEvent(event)) {
            return Collections.emptyList();
        }
        LOG.debug("Handling issue created event. # of contexts found: {0}", (Object)contexts.size());
        RuleMessage message = this.createRuleMessage(event);
        RuleExecutionCommandBuilder builder = this.ruleExecutionCommandBuilderService.builder().ruleMessage(message);
        ArrayList commands = Lists.newArrayList();
        for (WhenHandlerContext context : contexts) {
            if (!this.matchContext(context, event)) continue;
            RuleExecutionCommand command = builder.ruleReference(context.getRuleReference()).build();
            commands.add(command);
        }
        LOG.debug("# of matched rule references: {0}", (Object)commands.size());
        return commands;
    }

    private boolean isCreatedEvent(IssueEvent event) {
        return this.issueEventHelper.isCreatedEvent(event);
    }

    private boolean matchContext(@Nonnull WhenHandlerContext context, @Nonnull IssueEvent event) {
        return event.getIssue() != null && this.whenUtils.matchContextWithPermissionCheck(context, event.getIssue());
    }

    private RuleMessage createRuleMessage(IssueEvent event) {
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder();
        this.issueMessageHelper.setIssueData(builder, event.getIssue());
        this.eventTimeMessageHelper.setEventTime(builder, this.whenUtils.retrieveEventTimeOrNow((JiraEvent)event));
        ApplicationUser user = event.getUser();
        if (user != null) {
            this.userMessageHelper.setUser(builder, "currentUser", user.getKey());
        }
        return builder.build();
    }
}

