/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.servicedesk.internal.api.events.ApprovalRequestedEvent;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.EventTimeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.ApprovalMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.WhenUtils;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalRequiredEventWhenHandler
implements EventWhenHandler<ApprovalRequestedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ApprovalRequiredEventWhenHandler.class);
    private final WhenUtils whenUtils;
    private final IssueManager issueManager;
    private final RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService;
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final IssueMessageHelper issueMessageHelper;
    private final ApprovalMessageHelper approvalMessageHelper;
    private final UserMessageHelper userMessageHelper;
    private final EventTimeMessageHelper eventTimeMessageHelper;

    public ApprovalRequiredEventWhenHandler(WhenUtils whenUtils, IssueManager issueManager, RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService, RuleMessageBuilderService ruleMessageBuilderService, IssueMessageHelper issueMessageHelper, ApprovalMessageHelper approvalMessageHelper, UserMessageHelper userMessageHelper, EventTimeMessageHelper eventTimeMessageHelper) {
        this.whenUtils = whenUtils;
        this.issueManager = issueManager;
        this.ruleExecutionCommandBuilderService = ruleExecutionCommandBuilderService;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.issueMessageHelper = issueMessageHelper;
        this.approvalMessageHelper = approvalMessageHelper;
        this.userMessageHelper = userMessageHelper;
        this.eventTimeMessageHelper = eventTimeMessageHelper;
    }

    public Class<ApprovalRequestedEvent> getEventClass() {
        return ApprovalRequestedEvent.class;
    }

    public List<RuleExecutionCommand> handleEvent(@Nonnull List<WhenHandlerContext> contexts, @Nonnull ApprovalRequestedEvent event) {
        if (event.getApproverUserKeys().isEmpty()) {
            LOG.warn("Received ApprovalRequestedEvent with no approvers");
            return Collections.emptyList();
        }
        LOG.debug("Handling ApprovalRequestedEvent event. # of contexts found: " + contexts.size());
        Option commandsOpt = Option.option((Object)this.issueManager.getIssueObject(Long.valueOf(event.getIssueId()))).map(issue -> this.buildRuleExecutionCommands(contexts, (Issue)issue, event));
        return (List)commandsOpt.fold(() -> {
            LOG.error("Failed to retrieve issue with ID: {}", (Object)event.getIssueId());
            return Collections.emptyList();
        }, Function.identity());
    }

    private List<RuleExecutionCommand> buildRuleExecutionCommands(List<WhenHandlerContext> contexts, Issue issue, ApprovalRequestedEvent event) {
        RuleExecutionCommandBuilder builder = this.ruleExecutionCommandBuilderService.builder().ruleMessage(this.createRuleMessage(issue, event));
        return contexts.stream().filter(context -> this.whenUtils.matchContextWithPermissionCheck((WhenHandlerContext)context, issue)).map(context -> builder.ruleReference(context.getRuleReference()).build()).collect(Collectors.toList());
    }

    private RuleMessage createRuleMessage(Issue issue, ApprovalRequestedEvent event) {
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder();
        event.getInitiator().foreach(user -> this.userMessageHelper.setUser(builder, "currentUser", user.getKey()));
        this.issueMessageHelper.setIssueData(builder, issue);
        this.eventTimeMessageHelper.setEventTime(builder, event.getTime());
        this.approvalMessageHelper.setNewApprovers(builder, event.getApproverUserKeys());
        return builder.build();
    }
}

