/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.operation;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EditIssueFieldOperationManager {
    private final IssueFactory issueFactory;
    private final FieldLayoutManager fieldLayoutManager;

    @Autowired
    public EditIssueFieldOperationManager(IssueFactory issueFactory, FieldLayoutManager fieldLayoutManager) {
        this.issueFactory = issueFactory;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public Map<String, String[]> transformParametersForEdit(Issue issue, OrderableField field, Map<String, String[]> storedParams) {
        if ("labels".equals(field.getId())) {
            return this.createParamsForAddLabels(issue, storedParams);
        }
        if ("components".equals(field.getId())) {
            return this.createParamsForAddComponents(issue, field, storedParams);
        }
        return storedParams;
    }

    private Map<String, String[]> createParamsForAddLabels(Issue issue, Map<String, String[]> storedParams) {
        HashMap<String, String[]> updatedParams = new HashMap<String, String[]>(storedParams);
        Set existingLabels = issue.getLabels().stream().map(Label::getLabel).collect(Collectors.toSet());
        this.getStoredLabels(storedParams).forEach(storedLabels -> {
            HashSet updatedLabels = new HashSet(existingLabels);
            updatedLabels.addAll(storedLabels);
            updatedParams.put("labels", updatedLabels.toArray(new String[updatedLabels.size()]));
        });
        return updatedParams;
    }

    private Option<Set<String>> getStoredLabels(Map<String, String[]> storedParams) {
        return Option.option((Object)storedParams.get("labels")).map(Sets::newHashSet);
    }

    private Map<String, String[]> createParamsForAddComponents(Issue issue, OrderableField field, Map<String, String[]> storedParams) {
        Collection existingComponents = issue.getComponents();
        Collection<ProjectComponent> newComponents = this.getStoredParamComponents(issue, field, storedParams);
        HashSet<ProjectComponent> allComponents = new HashSet<ProjectComponent>(existingComponents);
        allComponents.addAll(newComponents);
        List allComponentIds = FpKit.map(allComponents, component -> component.getId().toString());
        HashMap<String, String[]> updatedParams = new HashMap<String, String[]>(storedParams);
        updatedParams.put("components", allComponentIds.toArray(new String[allComponentIds.size()]));
        return updatedParams;
    }

    private Collection<ProjectComponent> getStoredParamComponents(Issue issue, OrderableField field, Map<String, String[]> storedParams) {
        FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeId()).getFieldLayoutItem(field);
        MutableIssue tempMutableIssue = this.issueFactory.cloneIssue(issue);
        HashMap fieldValuesHolder = new HashMap();
        field.populateFromParams(fieldValuesHolder, storedParams);
        field.updateIssue(fieldLayoutItem, tempMutableIssue, fieldValuesHolder);
        return tempMutableIssue.getComponents();
    }
}

