/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.configuration;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueThenActionErrors;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EditIssueThenActionConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EditIssueThenActionConfigurationHelper.class);
    private static final String PROJECT_ID_KEY = "projectId";
    private static final String FIELD_ID_KEY = "fieldId";
    static final String FIELD_VALUE_KEY = "fieldValue";
    private static ObjectMapper objectMapper = new ObjectMapper();
    private final EditIssueThenActionErrors editIssueThenActionErrors;
    private final FieldManager fieldManager;
    private final ProjectService projectService;

    @Autowired
    public EditIssueThenActionConfigurationHelper(EditIssueThenActionErrors editIssueThenActionErrors, FieldManager fieldManager, ProjectService projectService) {
        this.editIssueThenActionErrors = editIssueThenActionErrors;
        this.fieldManager = fieldManager;
        this.projectService = projectService;
    }

    public Either<AnError, OrderableField> retrieveField(ConfigurationData data) {
        return StepsConverters.newerOption((Option)data.getValue(FIELD_ID_KEY)).toRight(this.editIssueThenActionErrors::FIELD_ID_REQUIRED).flatMap(fieldId -> io.atlassian.fugue.Option.option((Object)this.fieldManager.getOrderableField(fieldId)).toRight(() -> this.editIssueThenActionErrors.FIELD_NOT_FOUND((String)fieldId)));
    }

    io.atlassian.fugue.Option<String> retrieveFieldId(Map<String, String> data) {
        return io.atlassian.fugue.Option.option((Object)data.get(FIELD_ID_KEY));
    }

    public Either<AnError, Project> retrieveProject(ApplicationUser user, ConfigurationData data) {
        return Steps.begin((Either)StepsConverters.newerOption((Option)data.getValue(PROJECT_ID_KEY)).toRight(() -> this.editIssueThenActionErrors.PROJECT_ID_REQUIRED(user))).then(projectId -> this.retrieveProjectById(user, Long.valueOf(projectId))).yield((projectId, project) -> project);
    }

    io.atlassian.fugue.Option<Long> retrieveProjectId(Map<String, String> data) {
        return io.atlassian.fugue.Option.option((Object)data.get(PROJECT_ID_KEY)).map(Long::valueOf);
    }

    private Either<AnError, Project> retrieveProjectById(ApplicationUser user, long projectId) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectById(user, Long.valueOf(projectId));
        return Eithers.cond((boolean)getProjectResult.isValid(), (Object)this.editIssueThenActionErrors.PROJECT_NOT_FOUND(user), (Object)getProjectResult.get());
    }

    public Either<AnError, Map<String, String[]>> extractStoredFieldValue(ConfigurationData data) {
        return this.extractStoredFieldValueInternal((io.atlassian.fugue.Option<String>)StepsConverters.newerOption((Option)data.getValue(FIELD_VALUE_KEY)));
    }

    Either<AnError, Map<String, String[]>> extractStoredFieldValue(Map<String, String> data) {
        return this.extractStoredFieldValueInternal((io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.option((Object)data.get(FIELD_VALUE_KEY)));
    }

    io.atlassian.fugue.Option<String> serialiseFieldValue(Map<String, String[]> fieldValue) {
        try {
            return io.atlassian.fugue.Option.some((Object)objectMapper.writeValueAsString(fieldValue));
        }
        catch (IOException e) {
            LOG.error("Failed to serialise fieldValue map to JSON");
            return io.atlassian.fugue.Option.none();
        }
    }

    private Either<AnError, Map<String, String[]>> extractStoredFieldValueInternal(io.atlassian.fugue.Option<String> fieldValueOpt) {
        return fieldValueOpt.toRight(this.editIssueThenActionErrors::FIELD_VALUE_MISSING).flatMap(this::parseStoredFieldValue);
    }

    private Either<AnError, Map<String, String[]>> parseStoredFieldValue(String jsonValue) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        try {
            Map parsedValue = (Map)objectMapper.readValue(jsonValue, Map.class);
            for (Map.Entry entry : parsedValue.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof List) {
                    List valueAsList = (List)value;
                    result.put(key, valueAsList.toArray(new String[valueAsList.size()]));
                    continue;
                }
                if (value instanceof String) {
                    result.put(key, new String[]{(String)value});
                    continue;
                }
                return Either.left((Object)this.editIssueThenActionErrors.FIELD_VALUE_INVALID_JSON(value.toString()));
            }
            return Either.right(result);
        }
        catch (IOException e) {
            return Either.left((Object)this.editIssueThenActionErrors.FIELD_VALUE_PARSE_EXCEPTION(e.getMessage()));
        }
    }
}

