/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueFieldManager;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.analytics.EditIssueThenActionAnalytics;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.configuration.EditIssueThenActionConfigurationHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.operation.EditIssueFieldOperationManager;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Unit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class EditIssueThenActionHelper {
    private final IssueMessageHelper issueMessageHelper;
    private final IssueService issueService;
    private final EditIssueFieldManager editIssueFieldManager;
    private final EditIssueFieldOperationManager editIssueFieldOperationManager;
    private final EditIssueThenActionConfigurationHelper configurationHelper;
    private final EditIssueThenActionAnalytics editIssueThenActionAnalytics;

    @Autowired
    EditIssueThenActionHelper(IssueMessageHelper issueMessageHelper, IssueService issueService, EditIssueFieldManager editIssueFieldManager, EditIssueFieldOperationManager editIssueFieldOperationManager, EditIssueThenActionConfigurationHelper configurationHelper, EditIssueThenActionAnalytics editIssueThenActionAnalytics) {
        this.issueMessageHelper = issueMessageHelper;
        this.issueService = issueService;
        this.editIssueFieldManager = editIssueFieldManager;
        this.editIssueFieldOperationManager = editIssueFieldOperationManager;
        this.configurationHelper = configurationHelper;
        this.editIssueThenActionAnalytics = editIssueThenActionAnalytics;
    }

    io.atlassian.fugue.Either<AnError, RuleMessage> editIssue(ApplicationUser user, RuleMessage ruleMessage, ConfigurationData data) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.issueMessageHelper.getIssue(ruleMessage))).then(issue -> this.createIssueInputParamsWithFieldValues(data, (Issue)issue)).then((issue, issueInputParams) -> this.executeUpdate(user, (Issue)issue, (IssueInputParameters)issueInputParams)).yield((issue, issueInputParams, updatedUnit) -> ruleMessage);
    }

    io.atlassian.fugue.Either<AnError, Unit> validateFieldValue(ApplicationUser user, ConfigurationData data, OrderableField field) {
        return Steps.begin(this.configurationHelper.retrieveProject(user, data)).then(project -> this.configurationHelper.extractStoredFieldValue(data)).then((project, params) -> this.editIssueFieldManager.validateFieldValue((Project)project, field, this.arrayValuesToList((Map<String, String[]>)params))).yield((project, params, validationUnit) -> validationUnit);
    }

    private io.atlassian.fugue.Either<AnError, IssueInputParameters> createIssueInputParamsWithFieldValues(ConfigurationData data, Issue issue) {
        return Steps.begin(this.configurationHelper.extractStoredFieldValue(data)).then(storedParams -> this.configurationHelper.retrieveField(data)).yield((storedParams, field) -> {
            Map<String, String[]> updatedParams = this.editIssueFieldOperationManager.transformParametersForEdit(issue, (OrderableField)field, (Map<String, String[]>)storedParams);
            IssueInputParameters issueInputParams = this.issueService.newIssueInputParameters(updatedParams);
            issueInputParams.setSkipScreenCheck(true);
            issueInputParams.setRetainExistingValuesWhenParameterNotProvided(true, true);
            issueInputParams.addFieldToForcePresent(field.getId());
            return issueInputParams;
        });
    }

    private io.atlassian.fugue.Either<AnError, Unit> executeUpdate(ApplicationUser user, Issue issue, IssueInputParameters issueInputParams) {
        IssueService.UpdateValidationResult validationResult = this.issueService.validateUpdate(user, issue.getId(), issueInputParams);
        if (validationResult.isValid()) {
            IssueService.IssueResult updateResult = this.issueService.update(user, validationResult);
            if (updateResult.isValid()) {
                this.editIssueThenActionAnalytics.fireIssueEditedEvent(issue.getProjectId());
            }
            return Eithers.cond((boolean)updateResult.isValid(), (Object)this.toAnError(updateResult.getErrorCollection()), (Object)Unit.VALUE);
        }
        return io.atlassian.fugue.Either.left((Object)this.toAnError(validationResult.getErrorCollection()));
    }

    private Map<String, List<String>> arrayValuesToList(Map<String, String[]> params) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        params.entrySet().forEach(entry -> result.put((String)entry.getKey(), (List<String>)Arrays.asList((Object[])entry.getValue())));
        return result;
    }

    private AnError toAnError(ErrorCollection errorCollection) {
        String errorMessageStr = StringUtils.join((Iterable)errorCollection.getErrorMessages(), (String)", ");
        ErrorMessage errorMessage = ErrorMessage.builder().message(errorMessageStr).build();
        return new AnError(errorMessage, HttpStatusCode.BAD_REQUEST);
    }
}

