/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EditIssueThenActionErrors {
    private final ErrorResultHelper errorResultHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public EditIssueThenActionErrors(ErrorResultHelper errorResultHelper, JiraAuthenticationContext jiraAuthenticationContext) {
        this.errorResultHelper = errorResultHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public AnError PROJECT_ID_REQUIRED() {
        return this.PROJECT_ID_REQUIRED(this.jiraAuthenticationContext.getLoggedInUser());
    }

    public AnError PROJECT_ID_REQUIRED(ApplicationUser user) {
        return this.errorResultHelper.anError(user, HttpStatusCode.BAD_REQUEST, "sd.action.edit.issue.project.id.required", new Object[0]);
    }

    public AnError PROJECT_NOT_FOUND() {
        return this.PROJECT_NOT_FOUND(this.jiraAuthenticationContext.getLoggedInUser());
    }

    public AnError PROJECT_NOT_FOUND(ApplicationUser user) {
        return this.errorResultHelper.anError(user, HttpStatusCode.NOT_FOUND, "sd.action.edit.issue.project.not.found", new Object[0]);
    }

    public AnError PROJECT_ADMIN_REQUIRED() {
        return this.errorResultHelper.forbidden403("sd.action.edit.issue.project.admin.not.permitted", new Object[0]).build();
    }

    public AnError FIELD_ID_REQUIRED() {
        return this.errorResultHelper.badRequest400("sd.action.edit.issue.field.id.required", new Object[0]).build();
    }

    public AnError FIELD_NOT_FOUND(String fieldId) {
        return this.FIELD_NOT_FOUND(this.jiraAuthenticationContext.getLoggedInUser(), fieldId);
    }

    public AnError FIELD_NOT_FOUND(ApplicationUser user, String fieldId) {
        return this.errorResultHelper.anError(user, HttpStatusCode.NOT_FOUND, "sd.action.edit.issue.field.not.found", new Object[]{fieldId});
    }

    public AnError FIELD_VALUE_MISSING() {
        return this.errorResultHelper.anError(this.jiraAuthenticationContext.getLoggedInUser(), HttpStatusCode.BAD_REQUEST, "sd.action.edit.issue.field.value.missing", new Object[0]);
    }

    public AnError FIELD_VALUE_PARSE_EXCEPTION(String errorMessage) {
        return this.errorResultHelper.anError(this.jiraAuthenticationContext.getLoggedInUser(), HttpStatusCode.BAD_REQUEST, "sd.action.edit.issue.field.value.parse.error", new Object[]{errorMessage});
    }

    public AnError FIELD_VALUE_INVALID_JSON(String fieldValue) {
        return this.errorResultHelper.anError(this.jiraAuthenticationContext.getLoggedInUser(), HttpStatusCode.BAD_REQUEST, "sd.action.edit.issue.field.value.invalid", new Object[]{fieldValue});
    }

    public AnError FIELD_NOT_RENDERABLE() {
        return this.errorResultHelper.badRequest400("sd.action.edit.issue.field.not.renderable", new Object[0]).build();
    }

    public AnError NO_ISSUE_TYPES() {
        return this.errorResultHelper.badRequest400("sd.action.edit.issue.no.issue.types", new Object[0]).build();
    }
}

