/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueFieldManager;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueFieldService;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueThenActionErrors;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Unit;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class EditIssueFieldServiceImpl
implements EditIssueFieldService {
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskService serviceDeskService;
    private final EditIssueThenActionErrors editIssueThenActionErrors;
    private final EditIssueFieldManager editIssueFieldManager;

    @Autowired
    public EditIssueFieldServiceImpl(EditIssueFieldManager editIssueFieldManager, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskService serviceDeskService, EditIssueThenActionErrors editIssueThenActionErrors) {
        this.editIssueFieldManager = editIssueFieldManager;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskService = serviceDeskService;
        this.editIssueThenActionErrors = editIssueThenActionErrors;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<OrderableField>> retrieveEditableFields(CheckedUser user, Project project) {
        return this.checkIsAdminAgent(user, project).flatMap(permCheckedUnit -> this.editIssueFieldManager.retrieveEditableFields());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, String> retrieveFieldEditHtml(CheckedUser user, Project project, OrderableField field, Map<String, List<String>> params) {
        return this.checkIsAdminAgent(user, project).flatMap(permCheckedUnit -> this.editIssueFieldManager.retrieveFieldEditHtml(project, field, params));
    }

    private io.atlassian.fugue.Either<AnError, Unit> checkIsAdminAgent(CheckedUser user, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project))).then(serviceDesk -> StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user.forJIRA(), serviceDesk))).then((serviceDesk, isAdminAgent) -> Eithers.cond((boolean)isAdminAgent, (Object)this.editIssueThenActionErrors.PROJECT_ADMIN_REQUIRED(), (Object)Unit.VALUE)).yield((serviceDesk, isAdminAgent, unit) -> unit);
    }
}

