/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditFieldHtmlRenderer;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueThenActionErrors;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EditIssueFieldManager {
    private static final Set<String> SYSTEM_FIELD_IDS_WHITELIST = ImmutableSet.builder().add((Object)"assignee").add((Object)"priority").add((Object)"environment").add((Object)"issuelinks").add((Object)"labels").add((Object)"components").add((Object)"summary").add((Object)"description").add((Object)"duedate").build();
    private final FieldManager fieldManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final EditFieldHtmlRenderer editFieldHtmlRenderer;
    private final EditIssueThenActionErrors editIssueThenActionErrors;

    @Autowired
    public EditIssueFieldManager(FieldManager fieldManager, IssueTypeSchemeManager issueTypeSchemeManager, EditFieldHtmlRenderer editFieldHtmlRenderer, EditIssueThenActionErrors editIssueThenActionErrors) {
        this.fieldManager = fieldManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.editFieldHtmlRenderer = editFieldHtmlRenderer;
        this.editIssueThenActionErrors = editIssueThenActionErrors;
    }

    Either<AnError, List<OrderableField>> retrieveEditableFields() {
        Set allOrderableFields = this.fieldManager.getOrderableFields();
        return Either.right(this.filterValidOrderableFields(allOrderableFields));
    }

    Either<AnError, String> retrieveFieldEditHtml(Project project, OrderableField field, Map<String, List<String>> params) {
        return this.getDefaultOrFirstIssueType(project).flatMap(issueType -> this.editFieldHtmlRenderer.retrieveFieldEditHtml(project, (IssueType)issueType, field, params));
    }

    Either<AnError, Unit> validateFieldValue(Project project, OrderableField field, Map<String, List<String>> params) {
        return this.getDefaultOrFirstIssueType(project).flatMap(issueType -> this.editFieldHtmlRenderer.validateFieldValue(project, (IssueType)issueType, field, params));
    }

    private Either<AnError, IssueType> getDefaultOrFirstIssueType(Project project) {
        Option defaultOrFirstIssueType = Option.option((Object)this.issueTypeSchemeManager.getDefaultIssueType(project)).orElse(() -> Iterables.first((Iterable)project.getIssueTypes()));
        return defaultOrFirstIssueType.toRight(this.editIssueThenActionErrors::NO_ISSUE_TYPES);
    }

    private List<OrderableField> filterValidOrderableFields(Set<OrderableField> unfilteredOrderableFields) {
        Predicate<OrderableField> isEditableFieldPredicate = this.getIsEditableFieldPredicate();
        return unfilteredOrderableFields.stream().filter(isEditableFieldPredicate).collect(Collectors.toList());
    }

    private Predicate<OrderableField> getIsEditableFieldPredicate() {
        return field -> SYSTEM_FIELD_IDS_WHITELIST.contains(field.getId());
    }
}

