/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.WorkflowTransitionThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowTransitionThenActionVisualiser
implements RuleComponentVisualiser {
    private final I18nHelper i18nHelper;
    private final WorkflowTransitionThenActionHelper workflowTransitionThenActionHelper;

    @Autowired
    public WorkflowTransitionThenActionVisualiser(I18nHelper i18nHelper, WorkflowTransitionThenActionHelper workflowTransitionThenActionHelper) {
        this.i18nHelper = i18nHelper;
        this.workflowTransitionThenActionHelper = workflowTransitionThenActionHelper;
    }

    @Nonnull
    public String getName(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        return this.i18nHelper.getText("sd.action.workflow.transition.name");
    }

    @Nonnull
    public Option<String> getLabel(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        ApplicationUser user = ruleComponentVisualiserParam.getUser();
        Either workflowTargetEither = StepsConverters.olderEither(this.workflowTransitionThenActionHelper.getWorkflowActionName(user, ruleComponentVisualiserParam.ruleConfiguration()));
        if (workflowTargetEither.isLeft()) {
            return Option.some((Object)this.i18nHelper.getText("sd.component.missing.configuration.error"));
        }
        String workflowTarget = (String)workflowTargetEither.right().get();
        return Option.some((Object)this.i18nHelper.getText("sd.action.workflow.transition.label", workflowTarget));
    }
}

