/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.WorkflowTransitionThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenActionValidator;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;

public class WorkflowTransitionThenActionValidator
implements ThenActionValidator {
    private final WorkflowTransitionThenActionHelper workflowTransitionThenActionHelper;

    public WorkflowTransitionThenActionValidator(WorkflowTransitionThenActionHelper workflowTransitionThenActionHelper) {
        this.workflowTransitionThenActionHelper = workflowTransitionThenActionHelper;
    }

    public ValidationResult validate(@Nonnull ThenActionValidator.ThenActionValidationParam thenActionValidationParam) {
        ApplicationUser user = thenActionValidationParam.getUserToValidateWith();
        Either<ThenActionError, String> workflowActionNameEither = this.workflowTransitionThenActionHelper.getWorkflowActionName(user, thenActionValidationParam.getConfiguration().getData());
        if (workflowActionNameEither.isLeft()) {
            return this.workflowTransitionThenActionHelper.getValidationResultFromError(user, "sd.action.workflow.transition.missing.action");
        }
        String workflowActionName = (String)workflowActionNameEither.right().get();
        Option projectContextOption = thenActionValidationParam.getProjectContext();
        if (projectContextOption.isEmpty() || ((ProjectContext)projectContextOption.get()).getProjects().isEmpty()) {
            return ValidationResult.PASSED();
        }
        ProjectContext projectContext = (ProjectContext)projectContextOption.get();
        boolean projectsHasAction = this.workflowTransitionThenActionHelper.projectsHasAction(projectContext.getProjects(), workflowActionName);
        if (!projectsHasAction) {
            return this.workflowTransitionThenActionHelper.getValidationResultFromError(user, "sd.action.workflow.transition.invalid.action");
        }
        return ValidationResult.PASSED();
    }
}

