/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.modules.common.CommentType;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.ServiceDeskCommentThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenActionValidator;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class ServiceDeskCommentThenActionValidator
implements ThenActionValidator {
    private final ServiceDeskCommentThenActionHelper serviceDeskCommentThenActionHelper;
    private final FeatureManager featureManager;

    public ServiceDeskCommentThenActionValidator(@Nonnull ServiceDeskCommentThenActionHelper serviceDeskCommentThenActionHelper, @Nonnull FeatureManager featureManager) {
        this.serviceDeskCommentThenActionHelper = serviceDeskCommentThenActionHelper;
        this.featureManager = featureManager;
    }

    public ValidationResult validate(@Nonnull ThenActionValidator.ThenActionValidationParam thenActionValidationParam) {
        ConfigurationData data;
        ApplicationUser userToValidateWith = thenActionValidationParam.getUserToValidateWith();
        Map fieldErrors = (Map)this.serviceDeskCommentThenActionHelper.getCommentType(userToValidateWith, data = thenActionValidationParam.getConfiguration().getData()).fold(invalidCommentType -> this.generateCommentTypeError(userToValidateWith, "sd.action.servicedesk.comment.type.missing"), validCommentType -> this.processValidCommentType(userToValidateWith, data, (CommentType)((Object)validCommentType)));
        if (fieldErrors.isEmpty()) {
            return ValidationResult.PASSED();
        }
        return ValidationResult.FAILED((Map)fieldErrors);
    }

    private Map<String, List<String>> processValidCommentType(@Nonnull ApplicationUser userToValidateWith, @Nonnull ConfigurationData data, @Nonnull CommentType validCommentType) {
        return this.validateIncludeIssueDetailsCheckbox(userToValidateWith, data, validCommentType);
    }

    private Map<String, List<String>> generateCommentTypeError(@Nonnull ApplicationUser userToValidateWith, @Nonnull String message) {
        return this.serviceDeskCommentThenActionHelper.generateCommentTypeError(userToValidateWith, message);
    }

    private Map<String, List<String>> generateCommentError(@Nonnull ApplicationUser userToValidateWith, @Nonnull String message) {
        return this.serviceDeskCommentThenActionHelper.generateCommentError(userToValidateWith, message);
    }

    private Map<String, List<String>> validateIncludeIssueDetailsCheckbox(@Nonnull ApplicationUser userToValidateWith, @Nonnull ConfigurationData data, @Nonnull CommentType commentType) {
        return (Map)this.serviceDeskCommentThenActionHelper.getIncludeLinkedIssueDetails(userToValidateWith, data).fold(() -> this.validateCommentOnly(userToValidateWith, data), checkbox -> this.validateCommentWithLinkedIssueDetailsCheckbox(userToValidateWith, data, commentType, (Boolean)checkbox));
    }

    private Map<String, List<String>> validateComment(@Nonnull ApplicationUser userToValidateWith, @Nonnull ConfigurationData data, @Nonnull Function handleEmptyComment) {
        return (Map)StepsConverters.olderEither(this.serviceDeskCommentThenActionHelper.getComment(userToValidateWith, data)).fold(noCommentFound -> this.generateCommentError(userToValidateWith, "sd.action.servicedesk.comment.missing.comment"), handleEmptyComment);
    }

    private Map<String, List<String>> validateCommentWithLinkedIssueDetailsCheckbox(@Nonnull ApplicationUser userToValidateWith, @Nonnull ConfigurationData data, @Nonnull CommentType commentType, @Nonnull Boolean checked) {
        HashMap fieldErrors = Maps.newHashMap();
        fieldErrors.putAll(this.validateCheckboxWithCommentType(userToValidateWith, commentType, checked));
        fieldErrors.putAll(this.validateCommentWithCheckBox(userToValidateWith, data, checked));
        return ImmutableMap.copyOf((Map)fieldErrors);
    }

    private Map<String, List<String>> validateCheckboxWithCommentType(@Nonnull ApplicationUser userToValidateWith, @Nonnull CommentType commentType, @Nonnull Boolean checked) {
        if (commentType == CommentType.Public && checked.booleanValue()) {
            return this.generateCommentTypeError(userToValidateWith, "sd.action.servicedesk.comment.not.include.linked.issue.details.in.public");
        }
        return ImmutableMap.builder().build();
    }

    private Map<String, List<String>> validateCommentWithCheckBox(@Nonnull ApplicationUser userToValidateWith, @Nonnull ConfigurationData data, @Nonnull Boolean checked) {
        return this.validateComment(userToValidateWith, data, this.handleEmptyCommentWithCheckBox(userToValidateWith, checked));
    }

    private Function handleEmptyCommentWithCheckBox(@Nonnull ApplicationUser userToValidateWith, @Nonnull Boolean checked) {
        return comment -> StringUtils.isNotBlank((String)String.valueOf(comment)) || checked != false ? ImmutableMap.builder().build() : this.generateCommentError(userToValidateWith, "sd.action.servicedesk.comment.missing.comment");
    }

    private Map<String, List<String>> validateCommentOnly(@Nonnull ApplicationUser userToValidateWith, @Nonnull ConfigurationData data) {
        return this.validateComment(userToValidateWith, data, this.handleEmptyCommentOnly(userToValidateWith));
    }

    private Function handleEmptyCommentOnly(@Nonnull ApplicationUser userToValidateWith) {
        return comment -> StringUtils.isBlank((String)String.valueOf(comment)) ? this.generateCommentError(userToValidateWith, "sd.action.servicedesk.comment.missing.comment") : ImmutableMap.builder().build();
    }
}

