/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.common.CommentType;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.LinkedIssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.ServiceDeskCommentThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceDeskCommentThenAction
implements ThenAction {
    private static final String PREFIX_QUOTE = "{quote}%s\n";
    private static final String HORIZONTAL_RULER = "----\n";
    private static final String SUFFIX_QUOTE = "%s{quote}\n";
    private final IssueMessageHelper issueMessageHelper;
    private final ServiceDeskCommentThenActionHelper serviceDeskCommentThenActionHelper;
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final LinkedIssueMessageHelper linkedIssueMessageHelper;
    private final I18nHelper i18nHelper;

    @Autowired
    public ServiceDeskCommentThenAction(IssueMessageHelper issueMessageHelper, ServiceDeskCommentThenActionHelper serviceDeskCommentThenActionHelper, ThenActionErrorHelper thenActionErrorHelper, LinkedIssueMessageHelper linkedIssueMessageHelper, I18nHelper i18nHelper) {
        this.issueMessageHelper = issueMessageHelper;
        this.serviceDeskCommentThenActionHelper = serviceDeskCommentThenActionHelper;
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.linkedIssueMessageHelper = linkedIssueMessageHelper;
        this.i18nHelper = i18nHelper;
    }

    public Either<ThenActionError, RuleMessage> invoke(@Nonnull ThenAction.ThenActionParam thenActionParam) {
        Either serviceDeskCommentEither;
        ApplicationUser user = thenActionParam.getUser();
        ConfigurationData data = thenActionParam.getConfiguration().getData();
        Either issueEither = this.issueMessageHelper.getIssue(thenActionParam.getMessage());
        if (issueEither.isLeft()) {
            AnError anError = (AnError)issueEither.left().get();
            return this.thenActionErrorHelper.error(anError);
        }
        Either commentEither = StepsConverters.olderEither(this.serviceDeskCommentThenActionHelper.getComment(user, data));
        if (commentEither.isLeft()) {
            return Either.left((Object)commentEither.left().get());
        }
        Either commentTypeEither = StepsConverters.olderEither(this.serviceDeskCommentThenActionHelper.getCommentType(user, data));
        if (commentTypeEither.isLeft()) {
            return Either.left((Object)commentTypeEither.left().get());
        }
        String commentBody = (String)commentEither.right().get();
        Issue incidentIssue = (Issue)issueEither.right().get();
        CommentType commentType = (CommentType)((Object)commentTypeEither.right().get());
        Option linkedIssueDetailOpt = StepsConverters.olderOption(this.serviceDeskCommentThenActionHelper.getIncludeLinkedIssueDetails(user, data));
        if (((Boolean)linkedIssueDetailOpt.getOrElse((Object)false)).booleanValue()) {
            Either linkedIssueEither = StepsConverters.olderEither(this.linkedIssueMessageHelper.getLinkedIssue(thenActionParam.getMessage()));
            if (linkedIssueEither.isLeft()) {
                AnError anError = (AnError)linkedIssueEither.left().get();
                return this.thenActionErrorHelper.error(anError);
            }
            Issue linkedIssue = (Issue)linkedIssueEither.right().get();
            String linkedIssueStatus = this.constructLinkedIssueStatus(linkedIssue.getKey(), linkedIssue.getSummary(), linkedIssue.getStatus().getSimpleStatus(this.i18nHelper).getName());
            commentBody = this.constructFullCommentBody(linkedIssueStatus, commentBody);
        }
        if ((serviceDeskCommentEither = StepsConverters.olderEither(this.serviceDeskCommentThenActionHelper.makeComment(user, commentBody, incidentIssue, commentType))).isLeft()) {
            return this.thenActionErrorHelper.error((AnError)serviceDeskCommentEither.left().get());
        }
        return Either.right((Object)thenActionParam.getMessage());
    }

    private String constructLinkedIssueStatus(@Nonnull String issueKey, @Nonnull String issueSummary, @Nonnull String issueStatus) {
        return this.i18nHelper.getText("sd.action.linked.issue.comment.include.detail.status", issueKey, issueSummary, issueStatus);
    }

    private String constructFullCommentBody(@Nonnull String status, @Nonnull String comment) {
        String quoteStatus = String.format(PREFIX_QUOTE, status);
        String quoteComment = String.format(SUFFIX_QUOTE, comment);
        return quoteStatus.concat(HORIZONTAL_RULER).concat(quoteComment);
    }
}

