/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.RequestTypeThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenActionValidator;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RequestTypeThenActionValidator
implements ThenActionValidator {
    public static final String REQUEST_TYPE_TARGET_FIELD_NAME = "requestTypes";
    private final RequestTypeThenActionHelper requestTypeThenActionHelper;
    private final I18nHelper i18nHelper;

    public RequestTypeThenActionValidator(RequestTypeThenActionHelper requestTypeThenActionHelper, I18nHelper i18nHelper) {
        this.requestTypeThenActionHelper = requestTypeThenActionHelper;
        this.i18nHelper = i18nHelper;
    }

    public ValidationResult validate(ThenActionValidator.ThenActionValidationParam thenActionValidationParam) {
        Assertions.notNull((String)"thenActionValidationParam", (Object)thenActionValidationParam);
        Option projectContextOption = StepsConverters.newerOption((com.atlassian.fugue.Option)thenActionValidationParam.getProjectContext());
        if (projectContextOption.isEmpty() || ((ProjectContext)projectContextOption.get()).getProjects().isEmpty() || ((ProjectContext)projectContextOption.get()).getProjects().size() != 1) {
            return ValidationResult.PASSED();
        }
        ApplicationUser user = thenActionValidationParam.getUserToValidateWith();
        Either<ThenActionError, RequestType> requestTypeEither = this.requestTypeThenActionHelper.getRequestType(user, thenActionValidationParam.getConfiguration().getData());
        if (requestTypeEither.isLeft()) {
            return this.getValidationResultFromError(user, Lists.newArrayList((Object[])new String[]{"sd.action.request.type.validation.failed"}));
        }
        return ValidationResult.PASSED();
    }

    private ValidationResult getValidationResultFromError(ApplicationUser user, List<String> errorKeys) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"errorKeys", errorKeys);
        CopyOnWriteMap validationErrors = CopyOnWriteMap.newHashMap();
        List translatedErrors = Lists.transform(errorKeys, (Function)new Function<String, String>(){

            @Nullable
            public String apply(String errorKey) {
                return RequestTypeThenActionValidator.this.i18nHelper.getText(errorKey);
            }
        });
        validationErrors.put(REQUEST_TYPE_TARGET_FIELD_NAME, translatedErrors);
        return ValidationResult.FAILED((Map)validationErrors);
    }
}

