/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.RequestTypeThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class RequestTypeThenAction
implements ThenAction {
    private static final Logger log = LoggerFactory.getLogger(RequestTypeThenAction.class);
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final IssueMessageHelper issueMessageHelper;
    private final RequestTypeThenActionHelper requestTypeThenActionHelper;

    @Autowired
    public RequestTypeThenAction(ThenActionErrorHelper thenActionErrorHelper, IssueMessageHelper issueMessageHelper, RequestTypeThenActionHelper requestTypeThenActionHelper) {
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.issueMessageHelper = issueMessageHelper;
        this.requestTypeThenActionHelper = requestTypeThenActionHelper;
    }

    public Either<ThenActionError, RuleMessage> invoke(ThenAction.ThenActionParam thenActionParam) {
        Assertions.notNull((String)"thenActionParam", (Object)thenActionParam);
        RuleMessage message = thenActionParam.getMessage();
        ApplicationUser user = thenActionParam.getUser();
        Either issueEither = this.issueMessageHelper.getIssue(message);
        if (issueEither.isLeft()) {
            log.debug("Cannot find issue to act on. Can't execute action");
            return this.thenActionErrorHelper.error((AnError)issueEither.left().get());
        }
        Issue issue = (Issue)issueEither.right().get();
        Either requestTypeEither = StepsConverters.olderEither(this.requestTypeThenActionHelper.getRequestType(user, thenActionParam.getConfiguration().getData()));
        if (requestTypeEither.isLeft()) {
            return Either.left((Object)requestTypeEither.left().get());
        }
        RequestType requestType = (RequestType)requestTypeEither.right().get();
        Either customerRequestEither = StepsConverters.olderEither(this.requestTypeThenActionHelper.updateRequestType(user, issue, requestType));
        if (customerRequestEither.isLeft()) {
            return Either.left((Object)customerRequestEither.left().get());
        }
        this.issueMessageHelper.invalidateIssue(message);
        return Either.right((Object)message);
    }
}

