/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.AlertUserThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import com.atlassian.util.concurrent.Assertions;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class AlertUserThenActionVisualiser
implements RuleComponentVisualiser {
    private final I18nHelper i18nHelper;
    private final AlertUserThenActionHelper alertUserThenActionHelper;

    @Autowired
    public AlertUserThenActionVisualiser(I18nHelper i18nHelper, AlertUserThenActionHelper alertUserThenActionHelper) {
        this.i18nHelper = i18nHelper;
        this.alertUserThenActionHelper = alertUserThenActionHelper;
    }

    @Nonnull
    public String getName(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        Assertions.notNull((String)"ruleComponentVisualiserParam", (Object)ruleComponentVisualiserParam);
        return this.i18nHelper.getText("sd.action.alert.user.name");
    }

    @Nonnull
    public Option<String> getLabel(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        Assertions.notNull((String)"ruleComponentVisualiserParam", (Object)ruleComponentVisualiserParam);
        ApplicationUser user = ruleComponentVisualiserParam.getUser();
        Either configuredUserList = StepsConverters.olderEither(this.alertUserThenActionHelper.getConfiguredUserList(user, ruleComponentVisualiserParam.ruleConfiguration()));
        if (configuredUserList.isLeft()) {
            return Option.none();
        }
        List userKeysList = (List)configuredUserList.right().get();
        String labelFromUserKeys = this.alertUserThenActionHelper.getLabelFromUserKeys(user, userKeysList);
        return Option.some((Object)labelFromUserKeys);
    }
}

