/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.modules.common.CommentType;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDCommentVisibilityIfConditionHelper {
    public static final String COMMENT_TYPE_CONFIG_NAME_KEY = "commentType";
    private static final String COMMENT_TYPE_FIELD_NAME = "commentType";
    private final I18nHelper.BeanFactory i18nFactory;
    private final ServiceDeskCommentService serviceDeskCommentService;
    private final IfConditionErrorHelper ifConditionErrorHelper;

    @Autowired
    public SDCommentVisibilityIfConditionHelper(I18nHelper.BeanFactory i18nFactory, ServiceDeskCommentService serviceDeskCommentService, IfConditionErrorHelper ifConditionErrorHelper) {
        this.i18nFactory = i18nFactory;
        this.serviceDeskCommentService = serviceDeskCommentService;
        this.ifConditionErrorHelper = ifConditionErrorHelper;
    }

    @Nonnull
    public io.atlassian.fugue.Either<IfConditionError, Boolean> checkCommentMatchConfiguration(@Nonnull ApplicationUser user, @Nonnull Comment comment, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"comment", (Object)comment);
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        io.atlassian.fugue.Either<IfConditionError, CommentType> expectedCommentTypeEither = this.getCommentType(user, configurationData);
        if (expectedCommentTypeEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)expectedCommentTypeEither.left().get());
        }
        CommentType expectedCommentType = (CommentType)((Object)expectedCommentTypeEither.right().get());
        io.atlassian.fugue.Either<IfConditionError, Boolean> commentIsPublicEither = this.isCommentPublic(user, comment);
        if (commentIsPublicEither.isLeft()) {
            return io.atlassian.fugue.Either.right((Object)false);
        }
        Boolean commentIsPublic = (Boolean)commentIsPublicEither.right().get();
        Boolean isExpectedCommentTypePublic = expectedCommentType == CommentType.Public;
        return io.atlassian.fugue.Either.right((Object)(isExpectedCommentTypePublic == commentIsPublic ? 1 : 0));
    }

    @Nonnull
    public ValidationResult validateConfiguration(@Nonnull ApplicationUser userToValidateWith, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"userToValidateWith", (Object)userToValidateWith);
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        io.atlassian.fugue.Either<IfConditionError, CommentType> commentTypeEither = this.getCommentType(userToValidateWith, configurationData);
        if (commentTypeEither.isLeft()) {
            return this.createFieldError(userToValidateWith, "sd.if.sdcomment.visibility.expected.comment.type.missing");
        }
        return ValidationResult.PASSED();
    }

    @Nonnull
    public io.atlassian.fugue.Either<IfConditionError, String> getNameForConfiguration(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Either<IfConditionError, CommentType> commentTypeEither = this.getCommentType(user, configurationData);
        if (commentTypeEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)commentTypeEither.left().get());
        }
        CommentType commentType = (CommentType)((Object)commentTypeEither.right().get());
        if (commentType == CommentType.Public) {
            return io.atlassian.fugue.Either.right((Object)i18nHelper.getText("sd.if.sdcomment.visibility.name.public"));
        }
        return io.atlassian.fugue.Either.right((Object)i18nHelper.getText("sd.if.sdcomment.visibility.name.internal"));
    }

    @Nonnull
    private io.atlassian.fugue.Either<IfConditionError, CommentType> getCommentType(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Option commentTypeOption = StepsConverters.newerOption((Option)configurationData.getValue("commentType"));
        if (commentTypeOption.isEmpty() || StringUtils.isBlank((String)((String)commentTypeOption.get()))) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(i18nHelper.getText("sd.if.sdcomment.visibility.expected.comment.type.missing")));
        }
        String commentTypeString = (String)commentTypeOption.get();
        io.atlassian.fugue.Option<CommentType> commentType = CommentType.getCommentType(commentTypeString);
        if (commentType.isEmpty()) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(i18nHelper.getText("sd.if.sdcomment.visibility.expected.comment.type.missing")));
        }
        return io.atlassian.fugue.Either.right((Object)commentType.get());
    }

    @Nonnull
    private io.atlassian.fugue.Either<IfConditionError, Boolean> isCommentPublic(@Nonnull ApplicationUser user, @Nonnull Comment comment) {
        io.atlassian.fugue.Either serviceDeskCommentByJiraCommentEither = StepsConverters.newerEither((Either)this.serviceDeskCommentService.getServiceDeskCommentByJiraComment(user, comment));
        if (serviceDeskCommentByJiraCommentEither.isLeft()) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error((AnError)serviceDeskCommentByJiraCommentEither.left().get()));
        }
        ServiceDeskComment serviceDeskComment = (ServiceDeskComment)serviceDeskCommentByJiraCommentEither.right().get();
        return io.atlassian.fugue.Either.right((Object)serviceDeskComment.isPublic());
    }

    @Nonnull
    private ValidationResult createFieldError(@Nonnull ApplicationUser user, @Nonnull String i18nKey) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        HashMap errorList = Maps.newHashMap();
        errorList.put("commentType", Lists.newArrayList((Object[])new String[]{i18nHelper.getText(i18nKey)}));
        return ValidationResult.FAILED((Map)errorList);
    }
}

