/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.LinkTypeIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;

public class LinkTypeIfConditionVisualiser
implements RuleComponentVisualiser {
    private final I18nHelper i18nHelper;
    private final LinkTypeIfConditionHelper linkTypeIfConditionHelper;

    public LinkTypeIfConditionVisualiser(I18nHelper i18nHelper, LinkTypeIfConditionHelper linkTypeIfConditionHelper) {
        this.i18nHelper = i18nHelper;
        this.linkTypeIfConditionHelper = linkTypeIfConditionHelper;
    }

    @Nonnull
    public String getName(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        Assertions.notNull((String)"ruleComponentVisualiserParam", (Object)ruleComponentVisualiserParam);
        return this.i18nHelper.getText("sd.if.issue.linktype.name");
    }

    @Nonnull
    public Option<String> getLabel(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        Assertions.notNull((String)"ruleComponentVisualiserParam", (Object)ruleComponentVisualiserParam);
        Either selectedLinkTypeEither = StepsConverters.olderEither(this.linkTypeIfConditionHelper.getLinkTypeName(ruleComponentVisualiserParam.ruleConfiguration()));
        if (selectedLinkTypeEither.isLeft()) {
            return Option.some((Object)this.i18nHelper.getText("sd.component.missing.configuration.error"));
        }
        String selectedLinkType = (String)selectedLinkTypeEither.right().get();
        return Option.some((Object)selectedLinkType);
    }
}

