/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.modules.common.LinkTypeDirection;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.LinkTypeIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfConditionValidator;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class LinkTypeIfConditionValidator
implements IfConditionValidator {
    private final LinkTypeIfConditionHelper linkTypeIfConditionHelper;
    private final IssueLinkManager issueLinkManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public LinkTypeIfConditionValidator(@Nonnull LinkTypeIfConditionHelper linkTypeIfConditionHelper, @Nonnull IssueLinkManager issueLinkManager, @Nonnull GlobalPermissionManager globalPermissionManager, @Nonnull JiraAuthenticationContext jiraAuthenticationContext) {
        this.linkTypeIfConditionHelper = linkTypeIfConditionHelper;
        this.issueLinkManager = issueLinkManager;
        this.globalPermissionManager = globalPermissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public ValidationResult validate(@Nonnull IfConditionValidator.IfConditionValidationParam ifConditionValidationParam) {
        Assertions.notNull((String)"ifConditionValidationParam", (Object)ifConditionValidationParam);
        ConfigurationData data = ifConditionValidationParam.getConfiguration().getData();
        Either<IfConditionError, String> linkTypeIdEither = this.linkTypeIfConditionHelper.getLinkTypeId(data);
        Either<IfConditionError, LinkTypeDirection> linkTypeDirectionEither = this.linkTypeIfConditionHelper.getLinkTypeDirection(data);
        HashMap fieldErrors = Maps.newHashMap();
        if (!this.issueLinkManager.isLinkingEnabled()) {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            if (this.isJiraAdministrator(user)) {
                fieldErrors.putAll(this.linkTypeIfConditionHelper.generateLinkTypeActivateErrorIfAdmin("sd.if.issue.linktype.deactivated.admin"));
            } else {
                fieldErrors.putAll(this.linkTypeIfConditionHelper.generateLinkTypeActivateErrorIfNotAdmin("sd.if.issue.linktype.deactivated.not.admin"));
            }
        }
        if (linkTypeIdEither.isLeft() || linkTypeDirectionEither.isLeft()) {
            fieldErrors.putAll(this.linkTypeIfConditionHelper.generateLinkTypeIdError("sd.if.issue.linktype.not.in.list"));
        }
        if (!fieldErrors.isEmpty()) {
            return ValidationResult.FAILED((Map)fieldErrors);
        }
        return ValidationResult.PASSED();
    }

    private boolean isJiraAdministrator(@Nonnull ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

