/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.modules.common.LinkTypeDirection;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Internal
public class LinkTypeIfConditionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LinkTypeIfConditionHelper.class);
    private static final Gson GSON = new Gson();
    private static final Type GSON_LINK_TYPE_TYPE = new TypeToken<Map<String, List<String>>>(){}.getType();
    public static final String LINK_TYPE_ID = "linkTypeId";
    public static final String LINK_TYPE_DIRECTION = "linkTypeDirection";
    public static final String LINK_TYPE_NAME = "linkTypeName";
    public static final String LINK_TYPE_SET = "com.automation.issue.link.types";
    public static final String LINK_TYPE_ACTIVATE = "linkTypeActivated";
    public static final String ISSUE_LINKING_URL = "/secure/admin/ViewLinkTypes!default.jspa";
    private final IfConditionErrorHelper ifConditionErrorHelper;
    private final I18nHelper i18nHelper;
    private final IssueLinkService issueLinkService;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    @Autowired
    public LinkTypeIfConditionHelper(IfConditionErrorHelper ifConditionErrorHelper, I18nHelper i18nHelper, IssueLinkService issueLinkService, IssueLinkTypeManager issueLinkTypeManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.ifConditionErrorHelper = ifConditionErrorHelper;
        this.i18nHelper = i18nHelper;
        this.issueLinkService = issueLinkService;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    @Nonnull
    public io.atlassian.fugue.Either<IfConditionError, LinkTypeDirection> getLinkTypeDirection(@Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        io.atlassian.fugue.Option linkTypeDirectionOption = StepsConverters.newerOption((Option)configurationData.getValue(LINK_TYPE_DIRECTION));
        if (linkTypeDirectionOption.isEmpty() || StringUtils.isBlank((String)((String)linkTypeDirectionOption.get()))) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(this.i18nHelper.getText("sd.if.issue.linktype.missing")));
        }
        String linkTypeDirectionString = (String)linkTypeDirectionOption.get();
        io.atlassian.fugue.Option<LinkTypeDirection> linkTypeDirectionsOption = LinkTypeDirection.getLinkTypeDirection(linkTypeDirectionString);
        if (linkTypeDirectionsOption.isEmpty()) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(this.i18nHelper.getText("sd.if.issue.linktype.missing")));
        }
        return io.atlassian.fugue.Either.right((Object)linkTypeDirectionsOption.get());
    }

    @Nonnull
    public io.atlassian.fugue.Either<IfConditionError, String> getLinkTypeId(@Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        io.atlassian.fugue.Option linkTypeIdOption = StepsConverters.newerOption((Option)configurationData.getValue(LINK_TYPE_ID));
        if (!linkTypeIdOption.isDefined()) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(this.i18nHelper.getText("sd.if.issue.linktype.missing")));
        }
        String linkTypeId = (String)linkTypeIdOption.get();
        if (StringUtils.isNotBlank((String)linkTypeId) && this.isFeasibleIssueLink(linkTypeId)) {
            return io.atlassian.fugue.Either.right((Object)linkTypeId);
        }
        return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(this.i18nHelper.getText("sd.if.issue.linktype.missing")));
    }

    @VisibleForTesting
    boolean isFeasibleIssueLink(@Nonnull String issueLinkId) {
        Collection issueLinkTypes = this.issueLinkService.getIssueLinkTypes();
        for (IssueLinkType issueLinkType : issueLinkTypes) {
            if (!issueLinkType.getId().toString().equals(issueLinkId)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public io.atlassian.fugue.Either<IfConditionError, String> getLinkTypeName(@Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        io.atlassian.fugue.Option linkTypeNamedOption = StepsConverters.newerOption((Option)configurationData.getValue(LINK_TYPE_NAME));
        if (!linkTypeNamedOption.isDefined()) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(this.i18nHelper.getText("sd.if.issue.linktype.missing")));
        }
        if (linkTypeNamedOption.isEmpty() || StringUtils.isBlank((String)((String)linkTypeNamedOption.get()))) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(this.i18nHelper.getText("sd.if.issue.linktype.missing")));
        }
        return io.atlassian.fugue.Either.right((Object)linkTypeNamedOption.get());
    }

    @Nonnull
    public Map<String, List<String>> generateLinkTypeIdError(@Nonnull String i18nKey) {
        Assertions.notNull((String)"i18nKey", (Object)i18nKey);
        HashMap newFieldErrors = Maps.newHashMap();
        newFieldErrors.put(LINK_TYPE_ID, Lists.newArrayList((Object[])new String[]{this.i18nHelper.getText(i18nKey)}));
        return newFieldErrors;
    }

    @Nonnull
    public Map<String, List<String>> generateLinkTypeActivateErrorIfAdmin(@Nonnull String i18nKey) {
        Assertions.notNull((String)"i18nKey", (Object)i18nKey);
        HashMap newFieldErrors = Maps.newHashMap();
        String contextPath = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl() + ISSUE_LINKING_URL;
        String linkToIssueLinking = String.format("<a href='%s' target='_blank'>Enable issue linking</a>", contextPath);
        newFieldErrors.put(LINK_TYPE_ACTIVATE, Lists.newArrayList((Object[])new String[]{this.i18nHelper.getText(i18nKey, linkToIssueLinking)}));
        return newFieldErrors;
    }

    @Nonnull
    public Map<String, List<String>> generateLinkTypeActivateErrorIfNotAdmin(@Nonnull String i18nKey) {
        Assertions.notNull((String)"i18nKey", (Object)i18nKey);
        HashMap newFieldErrors = Maps.newHashMap();
        newFieldErrors.put(LINK_TYPE_ACTIVATE, Lists.newArrayList((Object[])new String[]{this.i18nHelper.getText(i18nKey)}));
        return newFieldErrors;
    }

    public void setLinkTypeData(@Nonnull RuleMessageBuilder builder, @Nonnull Map<IssueLinkType, List<LinkTypeDirection>> linkTypes) {
        Map<String, List<String>> transformedMap = this.transformToStringBasedMap(linkTypes);
        String serializedMap = GSON.toJson(transformedMap);
        builder.putValue(LINK_TYPE_SET, serializedMap);
    }

    @Nonnull
    @VisibleForTesting
    Map<String, List<String>> transformToStringBasedMap(@Nonnull Map<IssueLinkType, List<LinkTypeDirection>> linkTypes) {
        HashMap<String, ImmutableList> stringBasedMap = new HashMap<String, ImmutableList>();
        for (Map.Entry<IssueLinkType, List<LinkTypeDirection>> entry : linkTypes.entrySet()) {
            IssueLinkType linkType = entry.getKey();
            List<LinkTypeDirection> directions = entry.getValue();
            ArrayList<String> transformedList = new ArrayList<String>();
            for (LinkTypeDirection direction : directions) {
                transformedList.add(direction.toString());
            }
            stringBasedMap.put(linkType.getId().toString(), ImmutableList.copyOf(transformedList));
        }
        return ImmutableMap.copyOf(stringBasedMap);
    }

    @Nonnull
    public io.atlassian.fugue.Option<Map<IssueLinkType, List<LinkTypeDirection>>> getLinkTypeData(@Nonnull RuleMessage ruleMessage) {
        return StepsConverters.newerOption((Option)ruleMessage.getValue(LINK_TYPE_SET)).map(this::deserializeLinkType);
    }

    @Nonnull
    @VisibleForTesting
    protected Map<IssueLinkType, List<LinkTypeDirection>> deserializeLinkType(@Nonnull String serializedLinkType) {
        Map stringLinkTypes = (Map)GSON.fromJson(serializedLinkType, GSON_LINK_TYPE_TYPE);
        HashMap<IssueLinkType, ImmutableList> strongTypeMap = new HashMap<IssueLinkType, ImmutableList>();
        for (Map.Entry entry : stringLinkTypes.entrySet()) {
            String linkTypeId = (String)entry.getKey();
            List directions = (List)entry.getValue();
            ArrayList<Object> strongTypeList = new ArrayList<Object>();
            for (String direction : directions) {
                io.atlassian.fugue.Option<LinkTypeDirection> directionOpt = LinkTypeDirection.getLinkTypeDirection(direction);
                if (!directionOpt.isDefined()) {
                    LOG.warn("Couldn't get link type direction for %s", (Object)direction);
                    continue;
                }
                strongTypeList.add(directionOpt.get());
            }
            IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(Long.valueOf(Long.parseLong(linkTypeId)));
            strongTypeMap.put(issueLinkType, ImmutableList.copyOf(strongTypeList));
        }
        return ImmutableMap.copyOf(strongTypeMap);
    }
}

