/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.ResolutionChangeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.IssueResolutionChangedIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueResolutionChangedIfCondition
implements IfCondition {
    private static final Logger LOG = LoggerFactory.getLogger(IssueResolutionChangedIfCondition.class);
    private final ResolutionChangeMessageHelper resolutionChangeMessageHelper;
    private final IssueResolutionChangedIfConditionHelper issueResolutionChangedIfConditionHelper;
    private final I18nHelper i18nHelper;

    public IssueResolutionChangedIfCondition(ResolutionChangeMessageHelper resolutionChangeMessageHelper, IssueResolutionChangedIfConditionHelper issueResolutionChangedIfConditionHelper, I18nHelper i18nHelper) {
        this.resolutionChangeMessageHelper = resolutionChangeMessageHelper;
        this.issueResolutionChangedIfConditionHelper = issueResolutionChangedIfConditionHelper;
        this.i18nHelper = i18nHelper;
    }

    public Either<IfConditionError, Boolean> matches(@Nonnull IfCondition.IfConditionParam ifConditionParam) {
        Option<FieldChangeType> expectedResolutionChange = this.issueResolutionChangedIfConditionHelper.retrieveChangeTypeConfiguration(ifConditionParam);
        if (expectedResolutionChange.isEmpty()) {
            return this.handleMissingResolutionChangeConfiguration();
        }
        return this.matchExpectedResolutionChange(ifConditionParam, expectedResolutionChange);
    }

    Either<IfConditionError, Boolean> handleMissingResolutionChangeConfiguration() {
        return Either.left((Object)new IfConditionError(new ErrorMessage.Builder().message(this.i18nHelper.getText("sd.if.resolution.changed.no.configuration.value.available")).build(), HttpStatusCode.INTERNAL_SERVER_ERROR));
    }

    Either<IfConditionError, Boolean> matchExpectedResolutionChange(@Nonnull IfCondition.IfConditionParam ifConditionParam, Option<FieldChangeType> expectedResolutionChange) {
        switch ((FieldChangeType)expectedResolutionChange.get()) {
            case CLEAR: 
            case SET: {
                Option<FieldChangeType> resolutionChange = this.retrieveFieldChangeOfMessage(ifConditionParam);
                return Either.right((Object)expectedResolutionChange.equals(resolutionChange));
            }
        }
        LOG.error("UPDATE FieldChangeType not supported - only SET or CLEAR FieldChangeTypes are available");
        return Either.right((Object)false);
    }

    Option<FieldChangeType> retrieveFieldChangeOfMessage(@Nonnull IfCondition.IfConditionParam ifConditionParam) {
        return StepsConverters.olderOption(this.resolutionChangeMessageHelper.getResolutionChange(ifConditionParam.getMessage()));
    }
}

