/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.parser.JqlParseErrorMessage;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueJqlIfConditionHelper {
    private static final String JQL_CONFIG_KEY = "jql";
    private static final String JQL_FORM_FIELD_NAME = "jql";
    private final SearchService searchService;
    private final JqlQueryParser jqlQueryParser;
    private final I18nHelper i18nHelper;
    private final BuilderService builderService;
    private final IfConditionErrorHelper ifConditionErrorHelper;

    @Autowired
    public IssueJqlIfConditionHelper(SearchService searchService, JqlQueryParser jqlQueryParser, I18nHelper i18nHelper, BuilderService builderService, IfConditionErrorHelper ifConditionErrorHelper) {
        this.searchService = searchService;
        this.jqlQueryParser = jqlQueryParser;
        this.i18nHelper = i18nHelper;
        this.builderService = builderService;
        this.ifConditionErrorHelper = ifConditionErrorHelper;
    }

    @Nonnull
    public io.atlassian.fugue.Either<IfConditionError, String> getJql(@Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        io.atlassian.fugue.Option jqlOption = StepsConverters.newerOption((Option)configurationData.getValue("jql"));
        if (jqlOption.isEmpty()) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(this.i18nHelper.getText("sd.if.jql.missing.jql")));
        }
        return io.atlassian.fugue.Either.right((Object)jqlOption.get());
    }

    @Nonnull
    public List<String> validationJql(@Nonnull ApplicationUser user, @Nonnull String jql) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"jql", (Object)jql);
        ArrayList jqlQueryValidationError = Lists.newArrayList();
        io.atlassian.fugue.Either<IfConditionError, Query> queryEither = this.parseJql(jql);
        if (queryEither.isLeft()) {
            IfConditionError ifConditionError = (IfConditionError)queryEither.left().get();
            String message = ifConditionError.getMessage().getMessage();
            jqlQueryValidationError.add(message);
        } else {
            Query query = (Query)queryEither.right().get();
            MessageSet messageSet = this.searchService.validateQuery(user, query);
            if (messageSet.hasAnyErrors() && messageSet.getErrorMessages() != null) {
                jqlQueryValidationError.addAll(messageSet.getErrorMessages());
            }
            if (messageSet.hasAnyWarnings() && messageSet.getWarningMessages() != null) {
                jqlQueryValidationError.addAll(messageSet.getWarningMessages());
            }
        }
        return jqlQueryValidationError;
    }

    @Nonnull
    public io.atlassian.fugue.Either<IfConditionError, Query> parseJql(@Nonnull String jql) {
        Assertions.notNull((String)"jql", (Object)jql);
        try {
            Query query = this.jqlQueryParser.parseQuery(jql);
            return io.atlassian.fugue.Either.right((Object)query);
        }
        catch (JqlParseException exception) {
            return this.getParseExceptionError(exception);
        }
    }

    @Nonnull
    public ValidationResult getValidationResultFromError(@Nonnull List<String> errorKeys) {
        Assertions.notNull((String)"errorKeys", errorKeys);
        HashMap validationErrors = Maps.newHashMap();
        List translatedErrors = Lists.transform(errorKeys, (Function)new Function<String, String>(){

            @Nullable
            public String apply(String errorKey) {
                return IssueJqlIfConditionHelper.this.i18nHelper.getText(errorKey);
            }
        });
        validationErrors.put("jql", translatedErrors);
        return ValidationResult.FAILED((Map)validationErrors);
    }

    @Nonnull
    public ConfigurationData createConfigurationData(@Nonnull String jqlString) {
        Assertions.notNull((String)"jqlString", (Object)jqlString);
        return this.builderService.newConfigurationDataBuilder().put("jql", jqlString).build();
    }

    @Nonnull
    public ValidationResult getValidationResultFromError(@Nonnull String errorKey) {
        Assertions.notNull((String)"errorKey", (Object)errorKey);
        return this.getValidationResultFromError(Lists.newArrayList((Object[])new String[]{errorKey}));
    }

    @Nonnull
    public <T> io.atlassian.fugue.Either<IfConditionError, T> getParseExceptionError(@Nonnull JqlParseException jqlParseException) {
        JqlParseErrorMessage parseErrorMessage = jqlParseException.getParseErrorMessage();
        String localizedErrorMessage = parseErrorMessage.getLocalizedErrorMessage(this.i18nHelper);
        ErrorMessage errorMessage = ErrorMessage.builder().message(localizedErrorMessage, parseErrorMessage.getKey(), new Object[]{parseErrorMessage.getArguments()}).build();
        return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(errorMessage));
    }

    @Nonnull
    public <T> io.atlassian.fugue.Either<IfConditionError, T> getSearchExceptionError(@Nonnull SearchException searchException) {
        String localizedErrorMessage = searchException.getLocalizedMessage();
        return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(localizedErrorMessage));
    }
}

