/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.feature.customer.request.CustomerRequestStatusManager;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.StatusTransitionedMessageHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class CustomerVisibleStatusChangeIfConditionHelper {
    private final StatusTransitionedMessageHelper statusTransitionedMessageHelper;
    private final IfConditionErrorHelper ifConditionErrorHelper;
    private final I18nHelper.BeanFactory i18nFactory;
    private final IssueMessageHelper issueMessageHelper;
    private final CustomerRequestStatusManager customerRequestStatusManager;

    @Autowired
    public CustomerVisibleStatusChangeIfConditionHelper(StatusTransitionedMessageHelper statusTransitionedMessageHelper, IfConditionErrorHelper ifConditionErrorHelper, I18nHelper.BeanFactory i18nFactory, IssueMessageHelper issueMessageHelper, CustomerRequestStatusManager customerRequestStatusManager) {
        this.statusTransitionedMessageHelper = statusTransitionedMessageHelper;
        this.ifConditionErrorHelper = ifConditionErrorHelper;
        this.i18nFactory = i18nFactory;
        this.issueMessageHelper = issueMessageHelper;
        this.customerRequestStatusManager = customerRequestStatusManager;
    }

    Either<IfConditionError, String> retrieveCustomerVisibleFromStatus(ApplicationUser user, RuleMessage ruleMessage) {
        return (Either)StepsConverters.olderOption(this.statusTransitionedMessageHelper.getStatusTransitioned(ruleMessage)).toRight(() -> this.buildIfConditionError(user, "sd.if.customer.visible.status.from.missing", new String[0])).flatMap(statusChange -> this.retrieveCustomerVisibleStatus(user, ruleMessage, statusChange.getFromStatus())).fold(arg_0 -> ((IfConditionErrorHelper)this.ifConditionErrorHelper).error(arg_0), Either::right);
    }

    Either<IfConditionError, String> retrieveCustomerVisibleToStatus(ApplicationUser user, RuleMessage ruleMessage) {
        return (Either)StepsConverters.olderOption(this.statusTransitionedMessageHelper.getStatusTransitioned(ruleMessage)).toRight(() -> this.buildIfConditionError(user, "sd.if.customer.visible.status.to.missing", new String[0])).flatMap(statusChange -> this.retrieveCustomerVisibleStatus(user, ruleMessage, statusChange.getToStatus())).fold(arg_0 -> ((IfConditionErrorHelper)this.ifConditionErrorHelper).error(arg_0), Either::right);
    }

    Either<AnError, String> retrieveCustomerVisibleStatus(ApplicationUser user, RuleMessage ruleMessage, String statusId) {
        return Steps.begin((Either)this.issueMessageHelper.getIssue(ruleMessage)).then(issue -> StepsConverters.olderEither((io.atlassian.fugue.Either)this.customerRequestStatusManager.retrieveCustomerVisibleStatus(user, issue, statusId))).yield((issue, status) -> status);
    }

    private IfConditionError buildIfConditionError(ApplicationUser user, String i18nString, String ... args) {
        return (IfConditionError)this.ifConditionErrorHelper.error(this.i18nFactory.getInstance(user).getText(i18nString, (Object)args)).left().get();
    }
}

