/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.CustomerVisibleStatusChangeIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerVisibleStatusChangeIfCondition
implements IfCondition {
    private final CustomerVisibleStatusChangeIfConditionHelper ifConditionHelper;
    private static final Logger log = LoggerFactory.getLogger(CustomerVisibleStatusChangeIfCondition.class);

    @Autowired
    public CustomerVisibleStatusChangeIfCondition(CustomerVisibleStatusChangeIfConditionHelper ifConditionHelper) {
        this.ifConditionHelper = ifConditionHelper;
    }

    public Either<IfConditionError, Boolean> matches(@Nonnull IfCondition.IfConditionParam ifConditionParam) {
        ApplicationUser user = ifConditionParam.getUser();
        return Steps.begin(this.ifConditionHelper.retrieveCustomerVisibleFromStatus(user, ifConditionParam.getMessage())).then(fromStatus -> this.ifConditionHelper.retrieveCustomerVisibleToStatus(user, ifConditionParam.getMessage())).yield(this::statusTransitionMatches).leftMap(err -> {
            log.warn(err.getMessage().getMessage());
            return err;
        }).orElse(Either.right((Object)false));
    }

    private boolean statusTransitionMatches(String fromStatus, String toStatus) {
        return !toStatus.equals(fromStatus);
    }
}

