/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.CommentMessageHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class CommentStringMatcherIfCondition
implements IfCondition {
    public static final String MATCH_STRING_KEY = "matchString";
    public static final String CASE_SENSITIVE_KEY = "isCaseSensitive";
    private final IfConditionErrorHelper ifConditionErrorHelper;
    private final CommentMessageHelper commentMessageHelper;
    private final I18nHelper i18nHelper;

    @Autowired
    public CommentStringMatcherIfCondition(IfConditionErrorHelper ifConditionErrorHelper, CommentMessageHelper commentMessageHelper, I18nHelper i18nHelper) {
        this.ifConditionErrorHelper = ifConditionErrorHelper;
        this.commentMessageHelper = commentMessageHelper;
        this.i18nHelper = i18nHelper;
    }

    public Either<IfConditionError, Boolean> matches(@Nonnull IfCondition.IfConditionParam ifConditionParam) {
        Assertions.notNull((String)"ifConditionParam", (Object)ifConditionParam);
        Either commentEither = this.commentMessageHelper.getComment(ifConditionParam.getMessage());
        if (commentEither.isLeft()) {
            return this.ifConditionErrorHelper.error((AnError)commentEither.left().get());
        }
        Comment comment = (Comment)commentEither.right().get();
        Option matchStringOption = ifConditionParam.getConfiguration().getData().getValue(MATCH_STRING_KEY);
        if (matchStringOption.isDefined()) {
            String matchString = (String)matchStringOption.get();
            Option caseSensitiveOption = ifConditionParam.getConfiguration().getData().getValue(CASE_SENSITIVE_KEY);
            if (!caseSensitiveOption.isDefined() || Boolean.valueOf((String)caseSensitiveOption.get()) != false ? comment.getBody().contains(matchString) : comment.getBody().toLowerCase().contains(matchString.toLowerCase())) {
                return Either.right((Object)true);
            }
            return Either.right((Object)false);
        }
        return this.ifConditionErrorHelper.error((AnError)new IfConditionError(new ErrorMessage.Builder().message(this.i18nHelper.getText("sd.if.comment.string.matcher.empty.comment")).build(), HttpStatusCode.INTERNAL_SERVER_ERROR));
    }
}

