/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen.editissue;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen.editissue.EditFieldValuesRequest;
import com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen.editissue.EditIssueConfigResponse;
import com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen.editissue.FieldEditHtmlResponse;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueFieldService;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueThenActionErrors;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/then/edit-issue/{projectId}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class EditIssueThenActionResource {
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final ProjectService projectService;
    private final I18nHelper i18nHelper;
    private final EditIssueFieldService editIssueFieldService;
    private final EditIssueThenActionErrors editIssueThenActionErrors;
    private final FieldManager fieldManager;

    protected EditIssueThenActionResource(RestResponseHelper restResponseHelper, UserFactory userFactory, ProjectService projectService, I18nHelper i18nHelper, EditIssueFieldService editIssueFieldService, EditIssueThenActionErrors editIssueThenActionErrors, FieldManager fieldManager) {
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
        this.projectService = projectService;
        this.i18nHelper = i18nHelper;
        this.editIssueFieldService = editIssueFieldService;
        this.editIssueThenActionErrors = editIssueThenActionErrors;
        this.fieldManager = fieldManager;
    }

    @GET
    public Response retrieveConfiguration(@PathParam(value="projectId") Long projectId) {
        io.atlassian.fugue.Either configResponseEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.getProjectById((CheckedUser)user, (Option<Long>)Option.option((Object)projectId))).then(this.editIssueFieldService::retrieveEditableFields).yield((user, project, fields) -> this.buildConfigResponse((List<OrderableField>)fields));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)configResponseEither.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    @POST
    @Path(value="/field")
    public Response retrieveFieldEditHtml(@PathParam(value="projectId") Long projectId, EditFieldValuesRequest request) {
        io.atlassian.fugue.Either editHtmlEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.getProjectById((CheckedUser)user, (Option<Long>)Option.option((Object)projectId))).then((user, project) -> this.retrieveFieldEditHtml((CheckedUser)user, (Project)project, request)).yield((user, project, fieldEditHtml) -> this.buildFieldEditHtmlResponse((String)fieldEditHtml));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)editHtmlEither.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    private io.atlassian.fugue.Either<AnError, Project> getProjectById(CheckedUser user, Option<Long> projectIdOpt) {
        io.atlassian.fugue.Either projectIdEither = projectIdOpt.toRight(this.editIssueThenActionErrors::PROJECT_ID_REQUIRED);
        return projectIdEither.flatMap(projectId -> {
            ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectById(user.forJIRA(), projectId);
            return Eithers.cond((boolean)getProjectResult.isValid(), (Object)this.editIssueThenActionErrors.PROJECT_NOT_FOUND(), (Object)getProjectResult.get());
        });
    }

    private io.atlassian.fugue.Either<AnError, String> retrieveFieldEditHtml(CheckedUser user, Project project, EditFieldValuesRequest request) {
        Map params = (Map)Option.option(request.getFieldValue()).getOrElse(Collections.emptyMap());
        return this.retrieveFieldById((Option<String>)Option.option((Object)request.getFieldId())).flatMap(field -> this.editIssueFieldService.retrieveFieldEditHtml(user, project, (OrderableField)field, params));
    }

    private io.atlassian.fugue.Either<AnError, OrderableField> retrieveFieldById(Option<String> fieldIdOpt) {
        io.atlassian.fugue.Either fieldIdEither = fieldIdOpt.toRight(this.editIssueThenActionErrors::FIELD_ID_REQUIRED);
        return fieldIdEither.flatMap(fieldId -> Option.option((Object)this.fieldManager.getOrderableField(fieldId)).toRight(() -> this.editIssueThenActionErrors.FIELD_NOT_FOUND((String)fieldId)));
    }

    private Response buildConfigResponse(List<OrderableField> fields) {
        List<EditIssueConfigResponse.FieldResponse> fieldResponses = fields.stream().map(field -> new EditIssueConfigResponse.FieldResponse(field.getId(), this.i18nHelper.getText(field.getNameKey()))).collect(Collectors.toList());
        return this.restResponseHelper.ok((Object)new EditIssueConfigResponse(fieldResponses));
    }

    private Response buildFieldEditHtmlResponse(String editHtml) {
        return this.restResponseHelper.ok((Object)new FieldEditHtmlResponse(editHtml));
    }
}

