/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen.WorkflowTransitionActionResponse;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.WorkflowTransitionThenActionHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/then/workflowtransition")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class WorkflowTransitionRestResource {
    private final ProjectService projectService;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowTransitionThenActionHelper workflowTransitionThenActionHelper;

    public WorkflowTransitionRestResource(ProjectService projectService, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, JiraAuthenticationContext jiraAuthenticationContext, WorkflowTransitionThenActionHelper workflowTransitionThenActionHelper) {
        this.projectService = projectService;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.workflowTransitionThenActionHelper = workflowTransitionThenActionHelper;
    }

    @GET
    @Path(value="{projectKey}/allactions")
    public Response getAllWorkflowActionsForProject(@PathParam(value="projectKey") String projectKey) {
        if (StringUtils.isBlank((String)projectKey)) {
            return Response.status((int)HttpStatusCode.BAD_REQUEST).entity((Object)"projectKey is required").build();
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ProjectService.GetProjectResult projectByKey = this.projectService.getProjectByKey(user, projectKey);
        if (!projectByKey.isValid() || projectByKey.getProject() == null) {
            return Response.status((int)HttpStatusCode.BAD_REQUEST).entity((Object)"error retrieving project").build();
        }
        Project project = projectByKey.getProject();
        if (!this.hasProjectAdminPermission(user, project)) {
            return Response.status((int)HttpStatusCode.FORBIDDEN).entity((Object)"permission invalid").build();
        }
        Set<String> allUniqueActionNames = this.workflowTransitionThenActionHelper.getAllUniqueValidActionNamesForProject(project);
        ArrayList workflowActionResponses = Lists.newArrayList();
        for (String actionName : allUniqueActionNames) {
            workflowActionResponses.add(new WorkflowTransitionActionResponse(actionName));
        }
        return Response.ok((Object)workflowActionResponses).build();
    }

    private boolean hasProjectAdminPermission(@Nonnull ApplicationUser user, @Nonnull Project project) {
        return this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user) || this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

