/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.featureflag.ServiceDeskFeatureFlags;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.api.util.permission.PermissionSchemeHelper;
import com.atlassian.servicedesk.plugins.automation.modules.permission.AutomationJiraPermissionChecker;
import com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen.AlertUserRestResponse;
import com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen.AlertUserUserResponse;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/then/alertuser")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AlertUserRestResource {
    private final UserManager userManager;
    private final AutomationJiraPermissionChecker automationJiraPermisionChecker;
    private final AvatarService avatarService;
    private final UserSearchService jiraUserSearchService;
    private final UserSearchManager userSearchManager;
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final ProjectService projectService;
    private final UserFactory userFactory;
    private final PermissionSchemeHelper permissionSchemeHelper;
    private final FeatureManager featureManager;
    private static final int SEARCH_RESULTS_MAX = 20;

    public AlertUserRestResource(UserManager userManager, AutomationJiraPermissionChecker automationJiraPermisionChecker, AvatarService avatarService, UserSearchService jiraUserSearchService, UserSearchManager userSearchManager, UserSearchManagerHelper userSearchManagerHelper, ProjectService projectService, UserFactory userFactory, PermissionSchemeHelper permissionSchemeHelper, FeatureManager featureManager) {
        this.userManager = userManager;
        this.automationJiraPermisionChecker = automationJiraPermisionChecker;
        this.avatarService = avatarService;
        this.jiraUserSearchService = jiraUserSearchService;
        this.userSearchManager = userSearchManager;
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.projectService = projectService;
        this.userFactory = userFactory;
        this.permissionSchemeHelper = permissionSchemeHelper;
        this.featureManager = featureManager;
    }

    @GET
    public Response getUserDisplayData(@QueryParam(value="users") List<String> userKeys) {
        UncheckedUser uncheckedUser = this.userFactory.getUncheckedUser();
        if (!this.automationJiraPermisionChecker.hasProjectAdminOrGlobalAdminPermission(uncheckedUser.forJIRA())) {
            return Response.status((int)HttpStatusCode.FORBIDDEN).build();
        }
        List<AlertUserUserResponse> alertUserUserResponses = userKeys.stream().filter(StringUtils::isNotEmpty).map(arg_0 -> ((UserManager)this.userManager).getUserByKey(arg_0)).filter(Objects::nonNull).map(user -> this.convertUserToResponse((ApplicationUser)user, uncheckedUser.forJIRA())).collect(Collectors.toList());
        boolean canUseUserPicker = this.jiraUserSearchService.canPerformAjaxSearch(uncheckedUser.forJIRA());
        return Response.ok((Object)new AlertUserRestResponse(canUseUserPicker, alertUserUserResponses)).build();
    }

    @GET
    @Path(value="/search")
    public Response searchInternalUsersOnly(@QueryParam(value="usernameOrEmail") String usernameOrEmailQuery, @QueryParam(value="projectKey") String projectKey) {
        Stream searchResults;
        UncheckedUser uncheckedUser = this.userFactory.getUncheckedUser();
        boolean canUseUserPicker = this.jiraUserSearchService.canPerformAjaxSearch(uncheckedUser.forJIRA());
        if (!this.automationJiraPermisionChecker.hasProjectAdminOrGlobalAdminPermission(uncheckedUser.forJIRA()) || !canUseUserPicker) {
            return Response.status((int)HttpStatusCode.FORBIDDEN).build();
        }
        ProjectService.GetProjectResult result = this.projectService.getProjectByKey(uncheckedUser.forJIRA(), projectKey);
        if (!result.isValid() || result.getProject() == null) {
            return Response.status((int)HttpStatusCode.NOT_FOUND).build();
        }
        Project project = result.getProject();
        UserSearchParams params = this.userSearchManagerHelper.buildInternalOnlyUserSearchParams(project, Option.some((Object)20));
        if (this.featureManager.isEnabled(ServiceDeskFeatureFlags.USE_SEARCH_BY_PERMISSIONS)) {
            ImmutableList usersByPermissions = ImmutableList.copyOf((Collection)this.permissionSchemeHelper.getUsersByPermissionsOutOfCustomerContext(Collections.singleton(ProjectPermissions.BROWSE_PROJECTS), project));
            searchResults = this.userSearchManager.filterUsers((List)usersByPermissions, usernameOrEmailQuery, params, true);
        } else {
            searchResults = this.userSearchManager.search(usernameOrEmailQuery, params);
        }
        List<AlertUserUserResponse> alertUserUserResponses = searchResults.filter(Objects::nonNull).map(user -> this.convertUserToResponse((ApplicationUser)user, uncheckedUser.forJIRA())).collect(Collectors.toList());
        return Response.ok((Object)new AlertUserRestResponse(canUseUserPicker, alertUserUserResponses)).build();
    }

    protected AlertUserUserResponse convertUserToResponse(@NotNull ApplicationUser user, @NotNull ApplicationUser loggedInUser) {
        URI avatarURL = this.avatarService.getAvatarURL(loggedInUser, user);
        return new AlertUserUserResponse(user.getUsername(), user.getKey(), user.getDisplayName(), avatarURL.toString());
    }
}

